Liferay.Loader.define('segments-web$date-fns@1.30.1/is_tomorrow/index', ['module', 'exports', 'require', '../start_of_day/index'], function (module, exports, require) {
  var define = undefined;
  var startOfDay = require('../start_of_day/index');

  /**
   * @category Day Helpers
   * @summary Is the given date tomorrow?
   *
   * @description
   * Is the given date tomorrow?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is tomorrow
   *
   * @example
   * // If today is 6 October 2014, is 7 October 14:00:00 tomorrow?
   * var result = isTomorrow(new Date(2014, 9, 7, 14, 0))
   * //=> true
   */
  function isTomorrow(dirtyDate) {
    var tomorrow = new Date();
    tomorrow.setDate(tomorrow.getDate() + 1);
    return startOfDay(dirtyDate).getTime() === startOfDay(tomorrow).getTime();
  }

  module.exports = isTomorrow;
});
//# sourceMappingURL=index.js.map