Liferay.Loader.define('segments-web$date-fns@1.30.1/is_thursday/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Weekday Helpers
   * @summary Is the given date Thursday?
   *
   * @description
   * Is the given date Thursday?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is Thursday
   *
   * @example
   * // Is 25 September 2014 Thursday?
   * var result = isThursday(new Date(2014, 8, 25))
   * //=> true
   */
  function isThursday(dirtyDate) {
    return parse(dirtyDate).getDay() === 4;
  }

  module.exports = isThursday;
});
//# sourceMappingURL=index.js.map