Liferay.Loader.define('segments-web$date-fns@1.30.1/is_this_month/index', ['module', 'exports', 'require', '../is_same_month/index'], function (module, exports, require) {
  var define = undefined;
  var isSameMonth = require('../is_same_month/index');

  /**
   * @category Month Helpers
   * @summary Is the given date in the same month as the current date?
   *
   * @description
   * Is the given date in the same month as the current date?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is in this month
   *
   * @example
   * // If today is 25 September 2014, is 15 September 2014 in this month?
   * var result = isThisMonth(new Date(2014, 8, 15))
   * //=> true
   */
  function isThisMonth(dirtyDate) {
    return isSameMonth(new Date(), dirtyDate);
  }

  module.exports = isThisMonth;
});
//# sourceMappingURL=index.js.map