Liferay.Loader.define('segments-web$date-fns@1.30.1/is_same_second/index', ['module', 'exports', 'require', '../start_of_second/index'], function (module, exports, require) {
  var define = undefined;
  var startOfSecond = require('../start_of_second/index');

  /**
   * @category Second Helpers
   * @summary Are the given dates in the same second?
   *
   * @description
   * Are the given dates in the same second?
   *
   * @param {Date|String|Number} dateLeft - the first date to check
   * @param {Date|String|Number} dateRight - the second date to check
   * @returns {Boolean} the dates are in the same second
   *
   * @example
   * // Are 4 September 2014 06:30:15.000 and 4 September 2014 06:30.15.500
   * // in the same second?
   * var result = isSameSecond(
   *   new Date(2014, 8, 4, 6, 30, 15),
   *   new Date(2014, 8, 4, 6, 30, 15, 500)
   * )
   * //=> true
   */
  function isSameSecond(dirtyDateLeft, dirtyDateRight) {
    var dateLeftStartOfSecond = startOfSecond(dirtyDateLeft);
    var dateRightStartOfSecond = startOfSecond(dirtyDateRight);

    return dateLeftStartOfSecond.getTime() === dateRightStartOfSecond.getTime();
  }

  module.exports = isSameSecond;
});
//# sourceMappingURL=index.js.map