Liferay.Loader.define('segments-web$date-fns@1.30.1/is_same_quarter/index', ['module', 'exports', 'require', '../start_of_quarter/index'], function (module, exports, require) {
  var define = undefined;
  var startOfQuarter = require('../start_of_quarter/index');

  /**
   * @category Quarter Helpers
   * @summary Are the given dates in the same year quarter?
   *
   * @description
   * Are the given dates in the same year quarter?
   *
   * @param {Date|String|Number} dateLeft - the first date to check
   * @param {Date|String|Number} dateRight - the second date to check
   * @returns {Boolean} the dates are in the same quarter
   *
   * @example
   * // Are 1 January 2014 and 8 March 2014 in the same quarter?
   * var result = isSameQuarter(
   *   new Date(2014, 0, 1),
   *   new Date(2014, 2, 8)
   * )
   * //=> true
   */
  function isSameQuarter(dirtyDateLeft, dirtyDateRight) {
    var dateLeftStartOfQuarter = startOfQuarter(dirtyDateLeft);
    var dateRightStartOfQuarter = startOfQuarter(dirtyDateRight);

    return dateLeftStartOfQuarter.getTime() === dateRightStartOfQuarter.getTime();
  }

  module.exports = isSameQuarter;
});
//# sourceMappingURL=index.js.map