Liferay.Loader.define('segments-web$date-fns@1.30.1/is_same_iso_year/index', ['module', 'exports', 'require', '../start_of_iso_year/index'], function (module, exports, require) {
  var define = undefined;
  var startOfISOYear = require('../start_of_iso_year/index');

  /**
   * @category ISO Week-Numbering Year Helpers
   * @summary Are the given dates in the same ISO week-numbering year?
   *
   * @description
   * Are the given dates in the same ISO week-numbering year?
   *
   * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
   *
   * @param {Date|String|Number} dateLeft - the first date to check
   * @param {Date|String|Number} dateRight - the second date to check
   * @returns {Boolean} the dates are in the same ISO week-numbering year
   *
   * @example
   * // Are 29 December 2003 and 2 January 2005 in the same ISO week-numbering year?
   * var result = isSameISOYear(
   *   new Date(2003, 11, 29),
   *   new Date(2005, 0, 2)
   * )
   * //=> true
   */
  function isSameISOYear(dirtyDateLeft, dirtyDateRight) {
    var dateLeftStartOfYear = startOfISOYear(dirtyDateLeft);
    var dateRightStartOfYear = startOfISOYear(dirtyDateRight);

    return dateLeftStartOfYear.getTime() === dateRightStartOfYear.getTime();
  }

  module.exports = isSameISOYear;
});
//# sourceMappingURL=index.js.map