Liferay.Loader.define('segments-web$date-fns@1.30.1/is_same_day/index', ['module', 'exports', 'require', '../start_of_day/index'], function (module, exports, require) {
  var define = undefined;
  var startOfDay = require('../start_of_day/index');

  /**
   * @category Day Helpers
   * @summary Are the given dates in the same day?
   *
   * @description
   * Are the given dates in the same day?
   *
   * @param {Date|String|Number} dateLeft - the first date to check
   * @param {Date|String|Number} dateRight - the second date to check
   * @returns {Boolean} the dates are in the same day
   *
   * @example
   * // Are 4 September 06:00:00 and 4 September 18:00:00 in the same day?
   * var result = isSameDay(
   *   new Date(2014, 8, 4, 6, 0),
   *   new Date(2014, 8, 4, 18, 0)
   * )
   * //=> true
   */
  function isSameDay(dirtyDateLeft, dirtyDateRight) {
    var dateLeftStartOfDay = startOfDay(dirtyDateLeft);
    var dateRightStartOfDay = startOfDay(dirtyDateRight);

    return dateLeftStartOfDay.getTime() === dateRightStartOfDay.getTime();
  }

  module.exports = isSameDay;
});
//# sourceMappingURL=index.js.map