Liferay.Loader.define('segments-web$date-fns@1.30.1/is_past/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Common Helpers
   * @summary Is the given date in the past?
   *
   * @description
   * Is the given date in the past?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is in the past
   *
   * @example
   * // If today is 6 October 2014, is 2 July 2014 in the past?
   * var result = isPast(new Date(2014, 6, 2))
   * //=> true
   */
  function isPast(dirtyDate) {
    return parse(dirtyDate).getTime() < new Date().getTime();
  }

  module.exports = isPast;
});
//# sourceMappingURL=index.js.map