Liferay.Loader.define('segments-web$date-fns@1.30.1/is_monday/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Weekday Helpers
   * @summary Is the given date Monday?
   *
   * @description
   * Is the given date Monday?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is Monday
   *
   * @example
   * // Is 22 September 2014 Monday?
   * var result = isMonday(new Date(2014, 8, 22))
   * //=> true
   */
  function isMonday(dirtyDate) {
    return parse(dirtyDate).getDay() === 1;
  }

  module.exports = isMonday;
});
//# sourceMappingURL=index.js.map