Liferay.Loader.define('segments-web$date-fns@1.30.1/is_leap_year/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Year Helpers
   * @summary Is the given date in the leap year?
   *
   * @description
   * Is the given date in the leap year?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is in the leap year
   *
   * @example
   * // Is 1 September 2012 in the leap year?
   * var result = isLeapYear(new Date(2012, 8, 1))
   * //=> true
   */
  function isLeapYear(dirtyDate) {
    var date = parse(dirtyDate);
    var year = date.getFullYear();
    return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
  }

  module.exports = isLeapYear;
});
//# sourceMappingURL=index.js.map