Liferay.Loader.define('segments-web$date-fns@1.30.1/is_friday/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Weekday Helpers
   * @summary Is the given date Friday?
   *
   * @description
   * Is the given date Friday?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is Friday
   *
   * @example
   * // Is 26 September 2014 Friday?
   * var result = isFriday(new Date(2014, 8, 26))
   * //=> true
   */
  function isFriday(dirtyDate) {
    return parse(dirtyDate).getDay() === 5;
  }

  module.exports = isFriday;
});
//# sourceMappingURL=index.js.map