Liferay.Loader.define('segments-web$date-fns@1.30.1/is_equal/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Common Helpers
   * @summary Are the given dates equal?
   *
   * @description
   * Are the given dates equal?
   *
   * @param {Date|String|Number} dateLeft - the first date to compare
   * @param {Date|String|Number} dateRight - the second date to compare
   * @returns {Boolean} the dates are equal
   *
   * @example
   * // Are 2 July 2014 06:30:45.000 and 2 July 2014 06:30:45.500 equal?
   * var result = isEqual(
   *   new Date(2014, 6, 2, 6, 30, 45, 0)
   *   new Date(2014, 6, 2, 6, 30, 45, 500)
   * )
   * //=> false
   */
  function isEqual(dirtyLeftDate, dirtyRightDate) {
    var dateLeft = parse(dirtyLeftDate);
    var dateRight = parse(dirtyRightDate);
    return dateLeft.getTime() === dateRight.getTime();
  }

  module.exports = isEqual;
});
//# sourceMappingURL=index.js.map