Liferay.Loader.define('segments-web$date-fns@1.30.1/get_time/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Timestamp Helpers
   * @summary Get the milliseconds timestamp of the given date.
   *
   * @description
   * Get the milliseconds timestamp of the given date.
   *
   * @param {Date|String|Number} date - the given date
   * @returns {Number} the timestamp
   *
   * @example
   * // Get the timestamp of 29 February 2012 11:45:05.123:
   * var result = getTime(new Date(2012, 1, 29, 11, 45, 5, 123))
   * //=> 1330515905123
   */
  function getTime(dirtyDate) {
    var date = parse(dirtyDate);
    var timestamp = date.getTime();
    return timestamp;
  }

  module.exports = getTime;
});
//# sourceMappingURL=index.js.map