Liferay.Loader.define('segments-web$date-fns@1.30.1/get_overlapping_days_in_ranges/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  var MILLISECONDS_IN_DAY = 24 * 60 * 60 * 1000;

  /**
   * @category Range Helpers
   * @summary Get the number of days that overlap in two date ranges
   *
   * @description
   * Get the number of days that overlap in two date ranges
   *
   * @param {Date|String|Number} initialRangeStartDate - the start of the initial range
   * @param {Date|String|Number} initialRangeEndDate - the end of the initial range
   * @param {Date|String|Number} comparedRangeStartDate - the start of the range to compare it with
   * @param {Date|String|Number} comparedRangeEndDate - the end of the range to compare it with
   * @returns {Number} the number of days that overlap in two date ranges
   * @throws {Error} startDate of a date range cannot be after its endDate
   *
   * @example
   * // For overlapping date ranges adds 1 for each started overlapping day:
   * getOverlappingDaysInRanges(
   *   new Date(2014, 0, 10), new Date(2014, 0, 20), new Date(2014, 0, 17), new Date(2014, 0, 21)
   * )
   * //=> 3
   *
   * @example
   * // For non-overlapping date ranges returns 0:
   * getOverlappingDaysInRanges(
   *   new Date(2014, 0, 10), new Date(2014, 0, 20), new Date(2014, 0, 21), new Date(2014, 0, 22)
   * )
   * //=> 0
   */
  function getOverlappingDaysInRanges(dirtyInitialRangeStartDate, dirtyInitialRangeEndDate, dirtyComparedRangeStartDate, dirtyComparedRangeEndDate) {
    var initialStartTime = parse(dirtyInitialRangeStartDate).getTime();
    var initialEndTime = parse(dirtyInitialRangeEndDate).getTime();
    var comparedStartTime = parse(dirtyComparedRangeStartDate).getTime();
    var comparedEndTime = parse(dirtyComparedRangeEndDate).getTime();

    if (initialStartTime > initialEndTime || comparedStartTime > comparedEndTime) {
      throw new Error('The start of the range cannot be after the end of the range');
    }

    if (!(initialStartTime < comparedEndTime && comparedStartTime < initialEndTime)) {
      return 0;
    }

    var overlapStartDate = comparedStartTime < initialStartTime ? initialStartTime : comparedStartTime;

    var overlapEndDate = comparedEndTime > initialEndTime ? initialEndTime : comparedEndTime;

    return Math.ceil((overlapEndDate - overlapStartDate) / MILLISECONDS_IN_DAY);
  }

  module.exports = getOverlappingDaysInRanges;
});
//# sourceMappingURL=index.js.map