Liferay.Loader.define('segments-web$date-fns@1.30.1/get_month/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Month Helpers
   * @summary Get the month of the given date.
   *
   * @description
   * Get the month of the given date.
   *
   * @param {Date|String|Number} date - the given date
   * @returns {Number} the month
   *
   * @example
   * // Which month is 29 February 2012?
   * var result = getMonth(new Date(2012, 1, 29))
   * //=> 1
   */
  function getMonth(dirtyDate) {
    var date = parse(dirtyDate);
    var month = date.getMonth();
    return month;
  }

  module.exports = getMonth;
});
//# sourceMappingURL=index.js.map