Liferay.Loader.define('segments-web$date-fns@1.30.1/get_minutes/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Minute Helpers
   * @summary Get the minutes of the given date.
   *
   * @description
   * Get the minutes of the given date.
   *
   * @param {Date|String|Number} date - the given date
   * @returns {Number} the minutes
   *
   * @example
   * // Get the minutes of 29 February 2012 11:45:05:
   * var result = getMinutes(new Date(2012, 1, 29, 11, 45, 5))
   * //=> 45
   */
  function getMinutes(dirtyDate) {
    var date = parse(dirtyDate);
    var minutes = date.getMinutes();
    return minutes;
  }

  module.exports = getMinutes;
});
//# sourceMappingURL=index.js.map