Liferay.Loader.define('segments-web$date-fns@1.30.1/get_milliseconds/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Millisecond Helpers
   * @summary Get the milliseconds of the given date.
   *
   * @description
   * Get the milliseconds of the given date.
   *
   * @param {Date|String|Number} date - the given date
   * @returns {Number} the milliseconds
   *
   * @example
   * // Get the milliseconds of 29 February 2012 11:45:05.123:
   * var result = getMilliseconds(new Date(2012, 1, 29, 11, 45, 5, 123))
   * //=> 123
   */
  function getMilliseconds(dirtyDate) {
    var date = parse(dirtyDate);
    var milliseconds = date.getMilliseconds();
    return milliseconds;
  }

  module.exports = getMilliseconds;
});
//# sourceMappingURL=index.js.map