Liferay.Loader.define('segments-web$date-fns@1.30.1/get_iso_year/index', ['module', 'exports', 'require', '../parse/index', '../start_of_iso_week/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');
  var startOfISOWeek = require('../start_of_iso_week/index');

  /**
   * @category ISO Week-Numbering Year Helpers
   * @summary Get the ISO week-numbering year of the given date.
   *
   * @description
   * Get the ISO week-numbering year of the given date,
   * which always starts 3 days before the year's first Thursday.
   *
   * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
   *
   * @param {Date|String|Number} date - the given date
   * @returns {Number} the ISO week-numbering year
   *
   * @example
   * // Which ISO-week numbering year is 2 January 2005?
   * var result = getISOYear(new Date(2005, 0, 2))
   * //=> 2004
   */
  function getISOYear(dirtyDate) {
    var date = parse(dirtyDate);
    var year = date.getFullYear();

    var fourthOfJanuaryOfNextYear = new Date(0);
    fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
    fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
    var startOfNextYear = startOfISOWeek(fourthOfJanuaryOfNextYear);

    var fourthOfJanuaryOfThisYear = new Date(0);
    fourthOfJanuaryOfThisYear.setFullYear(year, 0, 4);
    fourthOfJanuaryOfThisYear.setHours(0, 0, 0, 0);
    var startOfThisYear = startOfISOWeek(fourthOfJanuaryOfThisYear);

    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }

  module.exports = getISOYear;
});
//# sourceMappingURL=index.js.map