Liferay.Loader.define('segments-web$date-fns@1.30.1/get_iso_weeks_in_year/index', ['module', 'exports', 'require', '../start_of_iso_year/index', '../add_weeks/index'], function (module, exports, require) {
  var define = undefined;
  var startOfISOYear = require('../start_of_iso_year/index');
  var addWeeks = require('../add_weeks/index');

  var MILLISECONDS_IN_WEEK = 604800000;

  /**
   * @category ISO Week-Numbering Year Helpers
   * @summary Get the number of weeks in an ISO week-numbering year of the given date.
   *
   * @description
   * Get the number of weeks in an ISO week-numbering year of the given date.
   *
   * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
   *
   * @param {Date|String|Number} date - the given date
   * @returns {Number} the number of ISO weeks in a year
   *
   * @example
   * // How many weeks are in ISO week-numbering year 2015?
   * var result = getISOWeeksInYear(new Date(2015, 1, 11))
   * //=> 53
   */
  function getISOWeeksInYear(dirtyDate) {
    var thisYear = startOfISOYear(dirtyDate);
    var nextYear = startOfISOYear(addWeeks(thisYear, 60));
    var diff = nextYear.valueOf() - thisYear.valueOf();
    // Round the number of weeks to the nearest integer
    // because the number of milliseconds in a week is not constant
    // (e.g. it's different in the week of the daylight saving time clock shift)
    return Math.round(diff / MILLISECONDS_IN_WEEK);
  }

  module.exports = getISOWeeksInYear;
});
//# sourceMappingURL=index.js.map