Liferay.Loader.define('segments-web$date-fns@1.30.1/get_day_of_year/index', ['module', 'exports', 'require', '../parse/index', '../start_of_year/index', '../difference_in_calendar_days/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');
  var startOfYear = require('../start_of_year/index');
  var differenceInCalendarDays = require('../difference_in_calendar_days/index');

  /**
   * @category Day Helpers
   * @summary Get the day of the year of the given date.
   *
   * @description
   * Get the day of the year of the given date.
   *
   * @param {Date|String|Number} date - the given date
   * @returns {Number} the day of year
   *
   * @example
   * // Which day of the year is 2 July 2014?
   * var result = getDayOfYear(new Date(2014, 6, 2))
   * //=> 183
   */
  function getDayOfYear(dirtyDate) {
    var date = parse(dirtyDate);
    var diff = differenceInCalendarDays(date, startOfYear(date));

    return diff + 1;
  }

  module.exports = getDayOfYear;
});
//# sourceMappingURL=index.js.map