Liferay.Loader.define("segments-web$date-fns@1.30.1/end_of_tomorrow/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  /**
   * @category Day Helpers
   * @summary Return the end of tomorrow.
   *
   * @description
   * Return the end of tomorrow.
   *
   * @returns {Date} the end of tomorrow
   *
   * @example
   * // If today is 6 October 2014:
   * var result = endOfTomorrow()
   * //=> Tue Oct 7 2014 23:59:59.999
   */
  function endOfTomorrow() {
    var now = new Date();
    var year = now.getFullYear();
    var month = now.getMonth();
    var day = now.getDate();

    var date = new Date(0);
    date.setFullYear(year, month, day + 1);
    date.setHours(23, 59, 59, 999);
    return date;
  }

  module.exports = endOfTomorrow;
});
//# sourceMappingURL=index.js.map