Liferay.Loader.define('segments-web$date-fns@1.30.1/end_of_second/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Second Helpers
   * @summary Return the end of a second for the given date.
   *
   * @description
   * Return the end of a second for the given date.
   * The result will be in the local timezone.
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the end of a second
   *
   * @example
   * // The end of a second for 1 December 2014 22:15:45.400:
   * var result = endOfSecond(new Date(2014, 11, 1, 22, 15, 45, 400))
   * //=> Mon Dec 01 2014 22:15:45.999
   */
  function endOfSecond(dirtyDate) {
    var date = parse(dirtyDate);
    date.setMilliseconds(999);
    return date;
  }

  module.exports = endOfSecond;
});
//# sourceMappingURL=index.js.map