Liferay.Loader.define('segments-web$date-fns@1.30.1/end_of_quarter/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Quarter Helpers
   * @summary Return the end of a year quarter for the given date.
   *
   * @description
   * Return the end of a year quarter for the given date.
   * The result will be in the local timezone.
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the end of a quarter
   *
   * @example
   * // The end of a quarter for 2 September 2014 11:55:00:
   * var result = endOfQuarter(new Date(2014, 8, 2, 11, 55, 0))
   * //=> Tue Sep 30 2014 23:59:59.999
   */
  function endOfQuarter(dirtyDate) {
    var date = parse(dirtyDate);
    var currentMonth = date.getMonth();

    date.setMonth(currentMonth - currentMonth % 3 + 3, 0);
    date.setHours(23, 59, 59, 999);
    return date;
  }

  module.exports = endOfQuarter;
});
//# sourceMappingURL=index.js.map