Liferay.Loader.define('segments-web$date-fns@1.30.1/end_of_iso_year/index', ['module', 'exports', 'require', '../get_iso_year/index', '../start_of_iso_week/index'], function (module, exports, require) {
  var define = undefined;
  var getISOYear = require('../get_iso_year/index');
  var startOfISOWeek = require('../start_of_iso_week/index');

  /**
   * @category ISO Week-Numbering Year Helpers
   * @summary Return the end of an ISO week-numbering year for the given date.
   *
   * @description
   * Return the end of an ISO week-numbering year,
   * which always starts 3 days before the year's first Thursday.
   * The result will be in the local timezone.
   *
   * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the end of an ISO week-numbering year
   *
   * @example
   * // The end of an ISO week-numbering year for 2 July 2005:
   * var result = endOfISOYear(new Date(2005, 6, 2))
   * //=> Sun Jan 01 2006 23:59:59.999
   */
  function endOfISOYear(dirtyDate) {
    var year = getISOYear(dirtyDate);
    var fourthOfJanuaryOfNextYear = new Date(0);
    fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
    fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
    var date = startOfISOWeek(fourthOfJanuaryOfNextYear);
    date.setMilliseconds(date.getMilliseconds() - 1);
    return date;
  }

  module.exports = endOfISOYear;
});
//# sourceMappingURL=index.js.map