Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_months/index', ['module', 'exports', 'require', '../parse/index', '../difference_in_calendar_months/index', '../compare_asc/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');
  var differenceInCalendarMonths = require('../difference_in_calendar_months/index');
  var compareAsc = require('../compare_asc/index');

  /**
   * @category Month Helpers
   * @summary Get the number of full months between the given dates.
   *
   * @description
   * Get the number of full months between the given dates.
   *
   * @param {Date|String|Number} dateLeft - the later date
   * @param {Date|String|Number} dateRight - the earlier date
   * @returns {Number} the number of full months
   *
   * @example
   * // How many full months are between 31 January 2014 and 1 September 2014?
   * var result = differenceInMonths(
   *   new Date(2014, 8, 1),
   *   new Date(2014, 0, 31)
   * )
   * //=> 7
   */
  function differenceInMonths(dirtyDateLeft, dirtyDateRight) {
    var dateLeft = parse(dirtyDateLeft);
    var dateRight = parse(dirtyDateRight);

    var sign = compareAsc(dateLeft, dateRight);
    var difference = Math.abs(differenceInCalendarMonths(dateLeft, dateRight));
    dateLeft.setMonth(dateLeft.getMonth() - sign * difference);

    // Math.abs(diff in full months - diff in calendar months) === 1 if last calendar month is not full
    // If so, result must be decreased by 1 in absolute value
    var isLastMonthNotFull = compareAsc(dateLeft, dateRight) === -sign;
    return sign * (difference - isLastMonthNotFull);
  }

  module.exports = differenceInMonths;
});
//# sourceMappingURL=index.js.map