Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_calendar_years/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Year Helpers
   * @summary Get the number of calendar years between the given dates.
   *
   * @description
   * Get the number of calendar years between the given dates.
   *
   * @param {Date|String|Number} dateLeft - the later date
   * @param {Date|String|Number} dateRight - the earlier date
   * @returns {Number} the number of calendar years
   *
   * @example
   * // How many calendar years are between 31 December 2013 and 11 February 2015?
   * var result = differenceInCalendarYears(
   *   new Date(2015, 1, 11),
   *   new Date(2013, 11, 31)
   * )
   * //=> 2
   */
  function differenceInCalendarYears(dirtyDateLeft, dirtyDateRight) {
    var dateLeft = parse(dirtyDateLeft);
    var dateRight = parse(dirtyDateRight);

    return dateLeft.getFullYear() - dateRight.getFullYear();
  }

  module.exports = differenceInCalendarYears;
});
//# sourceMappingURL=index.js.map