Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_calendar_weeks/index', ['module', 'exports', 'require', '../start_of_week/index'], function (module, exports, require) {
  var define = undefined;
  var startOfWeek = require('../start_of_week/index');

  var MILLISECONDS_IN_MINUTE = 60000;
  var MILLISECONDS_IN_WEEK = 604800000;

  /**
   * @category Week Helpers
   * @summary Get the number of calendar weeks between the given dates.
   *
   * @description
   * Get the number of calendar weeks between the given dates.
   *
   * @param {Date|String|Number} dateLeft - the later date
   * @param {Date|String|Number} dateRight - the earlier date
   * @param {Object} [options] - the object with options
   * @param {Number} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
   * @returns {Number} the number of calendar weeks
   *
   * @example
   * // How many calendar weeks are between 5 July 2014 and 20 July 2014?
   * var result = differenceInCalendarWeeks(
   *   new Date(2014, 6, 20),
   *   new Date(2014, 6, 5)
   * )
   * //=> 3
   *
   * @example
   * // If the week starts on Monday,
   * // how many calendar weeks are between 5 July 2014 and 20 July 2014?
   * var result = differenceInCalendarWeeks(
   *   new Date(2014, 6, 20),
   *   new Date(2014, 6, 5),
   *   {weekStartsOn: 1}
   * )
   * //=> 2
   */
  function differenceInCalendarWeeks(dirtyDateLeft, dirtyDateRight, dirtyOptions) {
    var startOfWeekLeft = startOfWeek(dirtyDateLeft, dirtyOptions);
    var startOfWeekRight = startOfWeek(dirtyDateRight, dirtyOptions);

    var timestampLeft = startOfWeekLeft.getTime() - startOfWeekLeft.getTimezoneOffset() * MILLISECONDS_IN_MINUTE;
    var timestampRight = startOfWeekRight.getTime() - startOfWeekRight.getTimezoneOffset() * MILLISECONDS_IN_MINUTE;

    // Round the number of days to the nearest integer
    // because the number of milliseconds in a week is not constant
    // (e.g. it's different in the week of the daylight saving time clock shift)
    return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_WEEK);
  }

  module.exports = differenceInCalendarWeeks;
});
//# sourceMappingURL=index.js.map