Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_calendar_iso_years/index', ['module', 'exports', 'require', '../get_iso_year/index'], function (module, exports, require) {
  var define = undefined;
  var getISOYear = require('../get_iso_year/index');

  /**
   * @category ISO Week-Numbering Year Helpers
   * @summary Get the number of calendar ISO week-numbering years between the given dates.
   *
   * @description
   * Get the number of calendar ISO week-numbering years between the given dates.
   *
   * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
   *
   * @param {Date|String|Number} dateLeft - the later date
   * @param {Date|String|Number} dateRight - the earlier date
   * @returns {Number} the number of calendar ISO week-numbering years
   *
   * @example
   * // How many calendar ISO week-numbering years are 1 January 2010 and 1 January 2012?
   * var result = differenceInCalendarISOYears(
   *   new Date(2012, 0, 1),
   *   new Date(2010, 0, 1)
   * )
   * //=> 2
   */
  function differenceInCalendarISOYears(dirtyDateLeft, dirtyDateRight) {
    return getISOYear(dirtyDateLeft) - getISOYear(dirtyDateRight);
  }

  module.exports = differenceInCalendarISOYears;
});
//# sourceMappingURL=index.js.map