Liferay.Loader.define('segments-web$date-fns@1.30.1/compare_asc/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Common Helpers
   * @summary Compare the two dates and return -1, 0 or 1.
   *
   * @description
   * Compare the two dates and return 1 if the first date is after the second,
   * -1 if the first date is before the second or 0 if dates are equal.
   *
   * @param {Date|String|Number} dateLeft - the first date to compare
   * @param {Date|String|Number} dateRight - the second date to compare
   * @returns {Number} the result of the comparison
   *
   * @example
   * // Compare 11 February 1987 and 10 July 1989:
   * var result = compareAsc(
   *   new Date(1987, 1, 11),
   *   new Date(1989, 6, 10)
   * )
   * //=> -1
   *
   * @example
   * // Sort the array of dates:
   * var result = [
   *   new Date(1995, 6, 2),
   *   new Date(1987, 1, 11),
   *   new Date(1989, 6, 10)
   * ].sort(compareAsc)
   * //=> [
   * //   Wed Feb 11 1987 00:00:00,
   * //   Mon Jul 10 1989 00:00:00,
   * //   Sun Jul 02 1995 00:00:00
   * // ]
   */
  function compareAsc(dirtyDateLeft, dirtyDateRight) {
    var dateLeft = parse(dirtyDateLeft);
    var timeLeft = dateLeft.getTime();
    var dateRight = parse(dirtyDateRight);
    var timeRight = dateRight.getTime();

    if (timeLeft < timeRight) {
      return -1;
    } else if (timeLeft > timeRight) {
      return 1;
    } else {
      return 0;
    }
  }

  module.exports = compareAsc;
});
//# sourceMappingURL=index.js.map