Liferay.Loader.define('segments-web$date-fns@1.30.1/closest_index_to/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Common Helpers
   * @summary Return an index of the closest date from the array comparing to the given date.
   *
   * @description
   * Return an index of the closest date from the array comparing to the given date.
   *
   * @param {Date|String|Number} dateToCompare - the date to compare with
   * @param {Date[]|String[]|Number[]} datesArray - the array to search
   * @returns {Number} an index of the date closest to the given date
   * @throws {TypeError} the second argument must be an instance of Array
   *
   * @example
   * // Which date is closer to 6 September 2015?
   * var dateToCompare = new Date(2015, 8, 6)
   * var datesArray = [
   *   new Date(2015, 0, 1),
   *   new Date(2016, 0, 1),
   *   new Date(2017, 0, 1)
   * ]
   * var result = closestIndexTo(dateToCompare, datesArray)
   * //=> 1
   */
  function closestIndexTo(dirtyDateToCompare, dirtyDatesArray) {
    if (!(dirtyDatesArray instanceof Array)) {
      throw new TypeError(toString.call(dirtyDatesArray) + ' is not an instance of Array');
    }

    var dateToCompare = parse(dirtyDateToCompare);
    var timeToCompare = dateToCompare.getTime();

    var result;
    var minDistance;

    dirtyDatesArray.forEach(function (dirtyDate, index) {
      var currentDate = parse(dirtyDate);
      var distance = Math.abs(timeToCompare - currentDate.getTime());
      if (result === undefined || distance < minDistance) {
        result = index;
        minDistance = distance;
      }
    });

    return result;
  }

  module.exports = closestIndexTo;
});
//# sourceMappingURL=index.js.map