Liferay.Loader.define('segments-web$date-fns@1.30.1/add_quarters/index', ['module', 'exports', 'require', '../add_months/index'], function (module, exports, require) {
  var define = undefined;
  var addMonths = require('../add_months/index');

  /**
   * @category Quarter Helpers
   * @summary Add the specified number of year quarters to the given date.
   *
   * @description
   * Add the specified number of year quarters to the given date.
   *
   * @param {Date|String|Number} date - the date to be changed
   * @param {Number} amount - the amount of quarters to be added
   * @returns {Date} the new date with the quarters added
   *
   * @example
   * // Add 1 quarter to 1 September 2014:
   * var result = addQuarters(new Date(2014, 8, 1), 1)
   * //=> Mon Dec 01 2014 00:00:00
   */
  function addQuarters(dirtyDate, dirtyAmount) {
    var amount = Number(dirtyAmount);

    return addMonths(dirtyDate, amount * 3);
  }

  module.exports = addQuarters;
});
//# sourceMappingURL=index.js.map