Liferay.Loader.define("segments-web@1.0.37/js/utils/utils.es", ['module', 'exports', 'require', 'segments-web$date-fns', 'frontend-js-metal-web$metal', './constants.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.generateGroupId = generateGroupId;
  exports.getPluralMessage = getPluralMessage;
  exports.getChildGroupIds = getChildGroupIds;
  exports.getSupportedOperatorsFromType = getSupportedOperatorsFromType;
  exports.insertAtIndex = insertAtIndex;
  exports.objectToFormData = objectToFormData;
  exports.removeAtIndex = removeAtIndex;
  exports.replaceAtIndex = replaceAtIndex;
  exports.sub = sub;
  exports.dateToInternationalHuman = dateToInternationalHuman;
  exports.jsDatetoYYYYMMDD = jsDatetoYYYYMMDD;
  exports.createNewGroup = void 0;

  var _dateFns = _interopRequireDefault(require("segments-web$date-fns"));

  var _metal = require("frontend-js-metal-web$metal");

  var _constants = require("./constants.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var GROUP_ID_NAMESPACE = 'group_';
  var SPLIT_REGEX = /({\d+})/g;
  /**
   * Creates a new group object with items.
   * @param {Array} items The items to add to the new group.
   * @return {Object} The new group object.
   */

  var createNewGroup = function createNewGroup(items) {
    return {
      conjunctionName: _constants.CONJUNCTIONS.AND,
      groupId: generateGroupId(),
      items: items
    };
  };
  /**
   * Generates a unique group id.
   * @return {string} The unique id.
   */

  exports.createNewGroup = createNewGroup;

  function generateGroupId() {
    return "".concat(GROUP_ID_NAMESPACE).concat((0, _metal.getUid)());
  }
  /**
   * Uses the singular language key if the count is 1. Otherwise uses the plural
   * language key.
   * @param {string} singular The language key in singular form.
   * @param {string} plural The language key in plural form.
   * @param {number} count The amount to display in the message.
   * @param {boolean} toString If the message should be converted to a string.
   * @return {(string|Array)} The translated message.
   */

  function getPluralMessage(singular, plural) {
    var count = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var toString = arguments.length > 3 ? arguments[3] : undefined;
    var message = count === 1 ? singular : plural;
    return sub(message, [count], toString);
  }
  /**
   * Gets a list of group ids from a criteria object.
   * Used for disallowing groups to be moved into its own deeper nested groups.
   * Example of returned value: ['group_02', 'group_03']
   * @param {Object} criteria The criteria object to search through.
   * @return {Array}
   */

  function getChildGroupIds(criteria) {
    var childGroupIds = [];

    if (criteria.items && criteria.items.length) {
      childGroupIds = criteria.items.reduce(function (groupIdList, item) {
        return item.groupId ? [].concat(_toConsumableArray(groupIdList), [item.groupId], _toConsumableArray(getChildGroupIds(item))) : groupIdList;
      }, []);
    }

    return childGroupIds;
  }
  /**
   * Gets the list of operators for a supported type.
   * Used for displaying the operators available for each criteria row.
   * @param {Array} operators The full list of supported operators.
   * @param {Object} propertyTypes A map of property types and the operators
   * supported for each type.
   * @param {string} type The type to get the supported operators for.
   */

  function getSupportedOperatorsFromType(operators, propertyTypes, type) {
    return operators.filter(function (operator) {
      var validOperators = propertyTypes[type];
      return validOperators && validOperators.includes(operator.name);
    });
  }
  /**
   * Inserts an item into a list at the specified index.
   * @param {*} item The item that will be inserted.
   * @param {Array} list The list where the item will be inserted into.
   * @param {number} index The position where the item will be inserted.
   * @return {Array}
   */

  function insertAtIndex(item, list, index) {
    return [].concat(_toConsumableArray(list.slice(0, index)), [item], _toConsumableArray(list.slice(index, list.length)));
  }
  /**
   * Converts an object of key value pairs to a form data object for passing
   * into a fetch body.
   * @param {Object} dataObject The data to be converted.
   */

  function objectToFormData(dataObject) {
    var formData = new FormData();
    Object.keys(dataObject).forEach(function (key) {
      formData.set(key, dataObject[key]);
    });
    return formData;
  }
  /**
   * Removes an item at the specified index.
   * @param {Array} list The list the where an item will be removed.
   * @param {number} index The position where the item will be removed.
   * @return {Array}
   */

  function removeAtIndex(list, index) {
    return list.filter(function (fItem, fIndex) {
      return fIndex !== index;
    });
  }
  /**
   * Replaces an item in a list at the specified index.
   * @param {*} item The item that will be added.
   * @param {Array} list The list where an item will be replaced.
   * @param {number} index The position where the item will be replaced.
   * @return {Array}
   */

  function replaceAtIndex(item, list, index) {
    return Object.assign(list, _defineProperty({}, index, item));
  }
  /**
   * Utility function for substituting variables into language keys.
   *
   * Examples:
   * sub(Liferay.Language.get('search-x'), ['all'])
   * => 'search all'
   * sub(Liferay.Language.get('search-x'), [<b>all<b>], false)
   * => 'search <b>all</b>'
   *
   * @param {string} langKey This is the language key used from our properties file
   * @param {string} args Arguments to pass into language key
   * @param {string} join Boolean used to indicate whether to call `.join()` on
   * the array before it is returned. Use `false` if subbing in JSX.
   * @return {(string|Array)}
   */

  function sub(langKey, args) {
    var join = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    var keyArray = langKey.split(SPLIT_REGEX).filter(function (val) {
      return val.length !== 0;
    });

    for (var i = 0; i < args.length; i++) {
      var arg = args[i];
      var indexKey = "{".concat(i, "}");
      var argIndex = keyArray.indexOf(indexKey);

      while (argIndex >= 0) {
        keyArray.splice(argIndex, 1, arg);
        argIndex = keyArray.indexOf(indexKey);
      }
    }

    return join ? keyArray.join('') : keyArray;
  }

  function dateToInternationalHuman(ISOString) {
    var localeKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : navigator.language;
    var date = new Date(ISOString);

    var intl = new Intl.DateTimeFormat(localeKey, {
      day: 'numeric',
      month: 'long',
      year: 'numeric'
    });
    return intl.format(date);
  }
  /**
   * Returns a YYYY-MM-DD date
   * based on a JS Date object
   *
   * @export
   * @param {Date} dateJsObject
   * @returns {string}
   */

  function jsDatetoYYYYMMDD(dateJsObject) {
    return _dateFns["default"].format(dateJsObject, 'YYYY-MM-DD');
  }
  //# sourceMappingURL=utils.es.js.map
});
//# sourceMappingURL=utils.es.js.map