Liferay.Loader.define("segments-web@1.0.37/js/components/title_editor/LocalizedInput.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './LocalizedDropdown.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _LocalizedDropdown = _interopRequireDefault(require("./LocalizedDropdown.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var LocalizedInput =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(LocalizedInput, _React$Component);

    function LocalizedInput(props) {
      var _this;

      _classCallCheck(this, LocalizedInput);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(LocalizedInput).call(this, props));

      _defineProperty(_assertThisInitialized(_this), "_handleLanguageChange", function (langKey) {
        _this.setState(function (prevState) {
          return {
            currentLang: langKey,
            currentValue: prevState.values[langKey] || ''
          };
        });
      });

      _defineProperty(_assertThisInitialized(_this), "_onChange", function (event, hasError) {
        _this.props.onChange(event, _this.state.values, hasError);
      });

      _defineProperty(_assertThisInitialized(_this), "_handleInputChange", function (event) {
        event.persist();
        var hasError = false;
        var value = event.target.value;

        _this.setState(function (prevState) {
          var newValues = _objectSpread({}, prevState.values, _defineProperty({}, prevState.currentLang, value));

          hasError = !_this._validateValues(newValues);
          return {
            availableLanguages: prevState.availableLanguages.map(function (lang) {
              var newLang = lang;

              if (lang.key === prevState.currentLang) {
                newLang = _objectSpread({}, lang, {
                  hasValue: value !== ''
                });
              }

              return newLang;
            }),
            currentValue: value,
            hasError: hasError,
            values: newValues
          };
        }, function () {
          return _this._onChange(event, hasError);
        });
      });

      var availableLanguages = props.availableLanguages,
          initialLanguageId = props.initialLanguageId,
          initialValues = props.initialValues;
      _this.state = {
        availableLanguages: Object.keys(availableLanguages).map(function (key) {
          var value = availableLanguages[key];
          return {
            hasValue: !!initialValues[key],
            key: key,
            value: value
          };
        }),
        currentLang: initialLanguageId,
        currentValue: initialValues[initialLanguageId] || '',
        values: initialValues
      };
      return _this;
    }

    _createClass(LocalizedInput, [{
      key: "_validateValues",
      value: function _validateValues(values) {
        var defaultLang = this.props.defaultLang;
        var parsedValue = values[defaultLang] && values[defaultLang].replace(/\s/g, '');
        return !!parsedValue;
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            defaultLang = _this$props.defaultLang,
            initialLanguageId = _this$props.initialLanguageId,
            initialOpen = _this$props.initialOpen,
            placeholder = _this$props.placeholder,
            readOnly = _this$props.readOnly;
        var _this$state = this.state,
            availableLanguages = _this$state.availableLanguages,
            currentValue = _this$state.currentValue,
            hasError = _this$state.hasError;
        var inputGroupItemClasses = (0, _classnames["default"])('input-group-item ml-2', {
          'has-error': hasError
        });
        return _react["default"].createElement("div", {
          className: "input-group input-localized input-localized-input"
        }, _react["default"].createElement(_LocalizedDropdown["default"], {
          availableLanguages: availableLanguages,
          defaultLang: defaultLang,
          initialLang: initialLanguageId,
          initialOpen: initialOpen,
          onLanguageChange: this._handleLanguageChange
        }), _react["default"].createElement("div", {
          className: inputGroupItemClasses
        }, _react["default"].createElement("input", {
          className: "field form-control form-control-inline language-value rounded",
          "data-testid": "localized-main-input",
          onChange: this._handleInputChange,
          placeholder: placeholder,
          readOnly: readOnly,
          type: "text",
          value: currentValue
        })));
      }
    }]);

    return LocalizedInput;
  }(_react["default"].Component);

  exports["default"] = LocalizedInput;

  _defineProperty(LocalizedInput, "propTypes", {
    availableLanguages: _propTypes["default"].object.isRequired,
    initialLanguageId: _propTypes["default"].string.isRequired,
    initialOpen: _propTypes["default"].bool,
    initialValues: _propTypes["default"].object,
    onChange: _propTypes["default"].func,
    placeholder: _propTypes["default"].string,
    readOnly: _propTypes["default"].bool
  });

  _defineProperty(LocalizedInput, "defaultProps", {
    initialOpen: false,
    initialValues: {},
    onChange: function onChange() {},
    placeholder: '',
    readOnly: false
  });
  //# sourceMappingURL=LocalizedInput.es.js.map
});
//# sourceMappingURL=LocalizedInput.es.js.map