Liferay.Loader.define("segments-web@1.0.37/js/components/criteria_sidebar/CriteriaSidebarCollapse.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'segments-web$date-fns', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../utils/constants.es', '../../utils/types.es', '../../utils/utils.es', './CriteriaSidebarItem.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _dateFns = _interopRequireDefault(require("segments-web$date-fns"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _constants = require("../../utils/constants.es");

  var _types = require("../../utils/types.es");

  var _utils = require("../../utils/utils.es");

  var _CriteriaSidebarItem = _interopRequireDefault(require("./CriteriaSidebarItem.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var INPUT_DATE_FORMAT = 'YYYY-MM-DD';
  /**
   * Returns a default value for a property provided.
   * @param {Object} property
   * @returns {string}
   */

  function getDefaultValue(property) {
    var options = property.options,
        type = property.type;
    var defaultValue = '';

    if (type === _constants.PROPERTY_TYPES.STRING && options && options.length) {
      defaultValue = options[0].value;
    } else if (type === _constants.PROPERTY_TYPES.DATE) {
      defaultValue = (0, _utils.jsDatetoYYYYMMDD)(new Date());
    } else if (type === _constants.PROPERTY_TYPES.DATE_TIME) {
      var simpleDate = (0, _utils.jsDatetoYYYYMMDD)(new Date());
      defaultValue = _dateFns["default"].parse(simpleDate, INPUT_DATE_FORMAT).toISOString();
    } else if (type === _constants.PROPERTY_TYPES.BOOLEAN) {
      defaultValue = 'true';
    } else if (type === _constants.PROPERTY_TYPES.INTEGER) {
      defaultValue = 0;
    } else if (type === _constants.PROPERTY_TYPES.DOUBLE) {
      defaultValue = '0.00';
    }

    return defaultValue;
  }

  var CriteriaSidebarCollapse =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CriteriaSidebarCollapse, _Component);

    function CriteriaSidebarCollapse() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, CriteriaSidebarCollapse);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(CriteriaSidebarCollapse)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "_filterProperties", function (searchValue) {
        var propertyGroup = _this.props.propertyGroups.find(function (propertyGroup) {
          return _this.props.propertyKey === propertyGroup.propertyKey;
        });

        var properties = propertyGroup ? propertyGroup.properties : [];
        return properties.filter(function (property) {
          var propertyLabel = property.label.toLowerCase();
          return propertyLabel.indexOf(searchValue.toLowerCase()) !== -1;
        });
      });

      _defineProperty(_assertThisInitialized(_this), "_handleClick", function (key, editing) {
        return function () {
          _this.props.onCollapseClick(key, editing);
        };
      });

      return _this;
    }

    _createClass(CriteriaSidebarCollapse, [{
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            propertyGroups = _this$props.propertyGroups,
            propertyKey = _this$props.propertyKey,
            searchValue = _this$props.searchValue;
        var propertyGroup = propertyGroups.find(function (propertyGroup) {
          return propertyKey === propertyGroup.propertyKey;
        });
        var properties = propertyGroup ? propertyGroup.properties : [];
        var filteredProperties = searchValue ? this._filterProperties(searchValue) : properties;
        return _react["default"].createElement("ul", {
          className: "list-unstyled sidebar-collapse-groups"
        }, propertyGroups.map(function (propertyGroup) {
          var active = propertyGroup.propertyKey === propertyKey;
          var activeClasses = (0, _classnames["default"])({
            active: active
          });
          var propertyListClasses = (0, _classnames["default"])('properties-list', activeClasses);
          var key = propertyGroup.propertyKey;
          return _react["default"].createElement("li", {
            className: "sidebar-collapse-".concat(propertyGroup.propertyKey),
            key: key
          }, _react["default"].createElement("div", {
            className: "sidebar-collapse-header-root",
            onClick: _this2._handleClick(key, active)
          }, _react["default"].createElement("a", {
            className: "d-flex justify-content-between sidebar-collapse-header"
          }, propertyGroup.name, _react["default"].createElement("span", {
            className: "collapse-icon"
          }, _react["default"].createElement(_icon["default"], {
            className: activeClasses,
            symbol: "angle-right"
          })))), _react["default"].createElement("ul", {
            className: propertyListClasses
          }, active && filteredProperties.length === 0 && _react["default"].createElement("li", {
            className: "empty-message"
          }, Liferay.Language.get('no-results-were-found')), active && filteredProperties.length > 0 && filteredProperties.map(function (_ref) {
            var label = _ref.label,
                name = _ref.name,
                options = _ref.options,
                type = _ref.type;
            var defaultValue = getDefaultValue({
              label: label,
              name: name,
              options: options,
              type: type
            });
            return _react["default"].createElement(_CriteriaSidebarItem["default"], {
              className: "color--".concat(key),
              defaultValue: defaultValue,
              key: name,
              label: label,
              name: name,
              propertyKey: key,
              type: type
            });
          })));
        }));
      }
    }]);

    return CriteriaSidebarCollapse;
  }(_react.Component);

  _defineProperty(CriteriaSidebarCollapse, "propTypes", {
    onCollapseClick: _propTypes["default"].func,
    propertyGroups: _propTypes["default"].arrayOf(_types.propertyGroupShape),
    propertyKey: _propTypes["default"].string,
    searchValue: _propTypes["default"].string
  });

  var _default = CriteriaSidebarCollapse;
  exports["default"] = _default;
  //# sourceMappingURL=CriteriaSidebarCollapse.es.js.map
});
//# sourceMappingURL=CriteriaSidebarCollapse.es.js.map