Liferay.Loader.define("segments-web@1.0.37/js/components/criteria_builder/EmptyDropZone.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../../ThemeContext.es', '../../utils/drag-types.es', './EmptyPlaceholder.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _ThemeContext = _interopRequireDefault(require("../../ThemeContext.es"));

  var _dragTypes = require("../../utils/drag-types.es");

  var _EmptyPlaceholder = _interopRequireDefault(require("./EmptyPlaceholder.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Prevents items from being dropped from other contributors.
   * This method must be called `canDrop`.
   * @param {Object} props Component's current props.
   * @param {DropTargetMonitor} monitor
   * @returns {boolean} True if the target should accept the item.
   */
  function canDrop(props, monitor) {
    var destPropertyKey = props.propertyKey;

    var _monitor$getItem = monitor.getItem(),
        startPropertyKey = _monitor$getItem.propertyKey;

    return destPropertyKey === startPropertyKey;
  }
  /**
   * Implements the behavior of what will occur when an item is dropped.
   * Adds the criterion dropped.
   * This method must be called `drop`.
   * @param {Object} props Component's current props.
   * @param {DropTargetMonitor} monitor
   */

  function drop(props, monitor) {
    var _monitor$getItem2 = monitor.getItem(),
        criterion = _monitor$getItem2.criterion;

    props.onCriterionAdd(0, criterion);
  }

  var EmptyDropZone =
  /*#__PURE__*/
  function (_Component) {
    _inherits(EmptyDropZone, _Component);

    function EmptyDropZone() {
      _classCallCheck(this, EmptyDropZone);

      return _possibleConstructorReturn(this, _getPrototypeOf(EmptyDropZone).apply(this, arguments));
    }

    _createClass(EmptyDropZone, [{
      key: "render",
      value: function render() {
        var _this$props = this.props,
            canDrop = _this$props.canDrop,
            connectDropTarget = _this$props.connectDropTarget,
            emptyContributors = _this$props.emptyContributors,
            hover = _this$props.hover;
        var displayEmptyDropZone = canDrop || !emptyContributors;
        var emptyZoneClasses = (0, _classnames["default"])('empty-drop-zone-root', {
          'empty-drop-zone-dashed border-primary rounded': displayEmptyDropZone && (!canDrop || !hover)
        });
        var targetClasses = (0, _classnames["default"])(emptyContributors ? 'empty-drop-zone-target' : 'drop-zone-target p-5', {
          'empty-drop-zone-target-solid dnd-hover border-primary rounded': canDrop && hover
        });
        return _react["default"].createElement("div", {
          className: emptyZoneClasses
        }, connectDropTarget(displayEmptyDropZone ? _react["default"].createElement("div", {
          className: targetClasses
        }, _react["default"].createElement("div", {
          className: "empty-drop-zone-indicator"
        })) : _react["default"].createElement("div", null, _react["default"].createElement(_EmptyPlaceholder["default"], null))));
      }
    }]);

    return EmptyDropZone;
  }(_react.Component);

  _defineProperty(EmptyDropZone, "contextType", _ThemeContext["default"]);

  _defineProperty(EmptyDropZone, "propTypes", {
    canDrop: _propTypes["default"].bool,
    connectDropTarget: _propTypes["default"].func,
    emptyContributors: _propTypes["default"].bool,
    hover: _propTypes["default"].bool,
    onCriterionAdd: _propTypes["default"].func.isRequired,
    propertyKey: _propTypes["default"].string.isRequired
  });

  var _default = (0, _reactDnd.DropTarget)(_dragTypes.DragTypes.PROPERTY, {
    canDrop: canDrop,
    drop: drop
  }, function (connect, monitor) {
    return {
      canDrop: monitor.canDrop(),
      connectDropTarget: connect.dropTarget(),
      hover: monitor.isOver()
    };
  })(EmptyDropZone);

  exports["default"] = _default;
  //# sourceMappingURL=EmptyDropZone.es.js.map
});
//# sourceMappingURL=EmptyDropZone.es.js.map