Liferay.Loader.define("segments-web@1.0.37/js/components/criteria_builder/DropZone.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../../utils/drag-types.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _dragTypes = require("../../utils/drag-types.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var CRITERIA_GROUP = _dragTypes.DragTypes.CRITERIA_GROUP,
      CRITERIA_ROW = _dragTypes.DragTypes.CRITERIA_ROW,
      PROPERTY = _dragTypes.DragTypes.PROPERTY;
  var acceptedDragTypes = [CRITERIA_GROUP, CRITERIA_ROW, PROPERTY];
  /**
   * Prevents groups from dropping within itself and all items from dropping into
   * a position that would not change its' current position.
   * This method must be called `canDrop`.
   * @param {Object} props Component's current props.
   * @param {DropTargetMonitor} monitor
   * @returns {boolean} True if the target should accept the item.
   */

  function canDrop(props, monitor) {
    var destIndex = props.dropIndex,
        destGroupId = props.groupId,
        destPropertyKey = props.propertyKey;

    var _monitor$getItem = monitor.getItem(),
        _monitor$getItem$chil = _monitor$getItem.childGroupIds,
        childGroupIds = _monitor$getItem$chil === void 0 ? [] : _monitor$getItem$chil,
        criterion = _monitor$getItem.criterion,
        startGroupId = _monitor$getItem.groupId,
        startIndex = _monitor$getItem.index,
        startPropertyKey = _monitor$getItem.propertyKey;

    var disallowedGroupIds = [criterion.groupId].concat(_toConsumableArray(childGroupIds));
    var sameOrNestedGroup = monitor.getItemType() === CRITERIA_GROUP && disallowedGroupIds.includes(destGroupId);

    return !(sameOrNestedGroup || startGroupId === destGroupId && (startIndex === destIndex || startIndex === destIndex - 1)) && destPropertyKey === startPropertyKey;
  }
  /**
   * Implements the behavior of what will occur when an item is dropped.
   * For properties dropped from the sidebar, a new criterion will be added.
   * For rows and groups being dropped, they will be moved to the dropped
   * position.
   * This method must be called `drop`.
   * @param {Object} props Component's current props.
   * @param {DropTargetMonitor} monitor
   */

  function drop(props, monitor) {
    var destIndex = props.dropIndex,
        destGroupId = props.groupId,
        onCriterionAdd = props.onCriterionAdd,
        onMove = props.onMove;

    var _monitor$getItem2 = monitor.getItem(),
        criterion = _monitor$getItem2.criterion,
        startGroupId = _monitor$getItem2.groupId,
        startIndex = _monitor$getItem2.index;

    var itemType = monitor.getItemType();

    if (itemType === PROPERTY) {
      onCriterionAdd(destIndex, criterion);
    } else if (itemType === CRITERIA_ROW || itemType === CRITERIA_GROUP) {
      onMove(startGroupId, startIndex, destGroupId, destIndex, criterion);
    }
  }

  var DropZone =
  /*#__PURE__*/
  function (_Component) {
    _inherits(DropZone, _Component);

    function DropZone() {
      _classCallCheck(this, DropZone);

      return _possibleConstructorReturn(this, _getPrototypeOf(DropZone).apply(this, arguments));
    }

    _createClass(DropZone, [{
      key: "render",
      value: function render() {
        var _this$props = this.props,
            before = _this$props.before,
            canDrop = _this$props.canDrop,
            connectDropTarget = _this$props.connectDropTarget,
            hover = _this$props.hover;
        var targetClasses = (0, _classnames["default"])('drop-zone-target', {
          'drop-zone-target-before': before
        });
        return _react["default"].createElement("div", {
          className: "drop-zone-root"
        }, connectDropTarget(_react["default"].createElement("div", {
          className: targetClasses
        }, canDrop && hover && _react["default"].createElement("div", {
          className: "drop-zone-indicator"
        }))));
      }
    }]);

    return DropZone;
  }(_react.Component);

  _defineProperty(DropZone, "propTypes", {
    before: _propTypes["default"].bool,
    canDrop: _propTypes["default"].bool,
    connectDropTarget: _propTypes["default"].func,
    dropIndex: _propTypes["default"].number.isRequired,
    groupId: _propTypes["default"].string.isRequired,
    hover: _propTypes["default"].bool,
    onCriterionAdd: _propTypes["default"].func.isRequired,
    onMove: _propTypes["default"].func.isRequired,
    propertyKey: _propTypes["default"].string.isRequired
  });

  var _default = (0, _reactDnd.DropTarget)(acceptedDragTypes, {
    canDrop: canDrop,
    drop: drop
  }, function (connect, monitor) {
    return {
      canDrop: monitor.canDrop(),
      connectDropTarget: connect.dropTarget(),
      hover: monitor.isOver()
    };
  })(DropZone);

  exports["default"] = _default;
  //# sourceMappingURL=DropZone.es.js.map
});
//# sourceMappingURL=DropZone.es.js.map