Liferay.Loader.define("segments-web@1.0.37/js/components/criteria_builder/CriteriaRow.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../../ThemeContext.es', '../../utils/constants.es', '../../utils/drag-types.es', '../../utils/utils.es', '../inputs/BooleanInput.es', '../inputs/CollectionInput.es', '../inputs/DateInput.es', '../inputs/DateTimeInput.es', '../inputs/DecimalInput.es', '../inputs/IntegerInput.es', '../inputs/SelectEntityInput.es', '../inputs/StringInput.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _form = require("@frontend-taglib-clay$clayui/form");

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = require("frontend-js-react-web$prop-types");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _ThemeContext = _interopRequireDefault(require("../../ThemeContext.es"));

  var _constants = require("../../utils/constants.es");

  var _dragTypes = require("../../utils/drag-types.es");

  var _utils = require("../../utils/utils.es");

  var _BooleanInput = _interopRequireDefault(require("../inputs/BooleanInput.es"));

  var _CollectionInput = _interopRequireDefault(require("../inputs/CollectionInput.es"));

  var _DateInput = _interopRequireDefault(require("../inputs/DateInput.es"));

  var _DateTimeInput = _interopRequireDefault(require("../inputs/DateTimeInput.es"));

  var _DecimalInput = _interopRequireDefault(require("../inputs/DecimalInput.es"));

  var _IntegerInput = _interopRequireDefault(require("../inputs/IntegerInput.es"));

  var _SelectEntityInput = _interopRequireDefault(require("../inputs/SelectEntityInput.es"));

  var _StringInput = _interopRequireDefault(require("../inputs/StringInput.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var acceptedDragTypes = [_dragTypes.DragTypes.CRITERIA_ROW, _dragTypes.DragTypes.PROPERTY];
  /**
   * Prevents rows from dropping onto itself and adding properties to not matching
   * contributors.
   * This method must be called `canDrop`.
   * @param {Object} props Component's current props.
   * @param {DropTargetMonitor} monitor
   * @returns {boolean} True if the target should accept the item.
   */

  function canDrop(props, monitor) {
    var destGroupId = props.groupId,
        destIndex = props.index,
        contributorPropertyKey = props.propertyKey;

    var _monitor$getItem = monitor.getItem(),
        startGroupId = _monitor$getItem.groupId,
        startIndex = _monitor$getItem.index,
        sidebarItemPropertyKey = _monitor$getItem.propertyKey;

    return (destGroupId !== startGroupId || destIndex !== startIndex) && contributorPropertyKey === sidebarItemPropertyKey;
  }
  /**
   * Implements the behavior of what will occur when an item is dropped.
   * Items dropped on top of rows will create a new grouping.
   * This method must be called `drop`.
   * @param {Object} props Component's current props.
   * @param {DropTargetMonitor} monitor
   */

  function drop(props, monitor) {
    var criterion = props.criterion,
        destGroupId = props.groupId,
        destIndex = props.index,
        onChange = props.onChange,
        onMove = props.onMove,
        supportedOperators = props.supportedOperators,
        supportedPropertyTypes = props.supportedPropertyTypes;

    var _monitor$getItem2 = monitor.getItem(),
        droppedCriterion = _monitor$getItem2.criterion,
        startGroupId = _monitor$getItem2.groupId,
        startIndex = _monitor$getItem2.index;

    var defaultValue = droppedCriterion.defaultValue,
        displayValue = droppedCriterion.displayValue,
        operatorName = droppedCriterion.operatorName,
        propertyName = droppedCriterion.propertyName,
        type = droppedCriterion.type,
        value = droppedCriterion.value;

    var operators = (0, _utils.getSupportedOperatorsFromType)(supportedOperators, supportedPropertyTypes, type);
    var newCriterion = {
      displayValue: displayValue,
      operatorName: operatorName ? operatorName : operators[0].name,
      propertyName: propertyName,
      value: value || defaultValue
    };
    var itemType = monitor.getItemType();
    var newGroup = (0, _utils.createNewGroup)([criterion, newCriterion]);

    if (itemType === _dragTypes.DragTypes.PROPERTY) {
      onChange(newGroup);
    } else if (itemType === _dragTypes.DragTypes.CRITERIA_ROW) {
      onMove(startGroupId, startIndex, destGroupId, destIndex, newGroup, true);
    }
  }
  /**
   * Passes the required values to the drop target.
   * This method must be called `beginDrag`.
   * @param {Object} props Component's current props
   * @returns {Object} The props to be passed to the drop target.
   */

  function beginDrag(_ref) {
    var criterion = _ref.criterion,
        groupId = _ref.groupId,
        index = _ref.index,
        propertyKey = _ref.propertyKey;
    return {
      criterion: criterion,
      groupId: groupId,
      index: index,
      propertyKey: propertyKey
    };
  }

  var CriteriaRow =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CriteriaRow, _Component);

    function CriteriaRow() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, CriteriaRow);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(CriteriaRow)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "_fetchEntityName", function () {
        var _this$props = _this.props,
            criterion = _this$props.criterion,
            entityName = _this$props.entityName,
            onChange = _this$props.onChange;
        var propertyName = criterion.propertyName,
            value = criterion.value;
        var data = Liferay.Util.ns(_this.context.namespace, {
          entityName: entityName,
          fieldName: propertyName,
          fieldValue: value
        });
        (0, _frontendJsWeb.fetch)(_this.context.requestFieldValueNameURL, {
          body: (0, _utils.objectToFormData)(data),
          method: 'POST'
        }).then(function (response) {
          return response.text();
        }).then(function (displayValue) {
          onChange(_objectSpread({}, criterion, {
            displayValue: displayValue
          }));
        });
      });

      _defineProperty(_assertThisInitialized(_this), "_getReadableCriteriaString", function (_ref2) {
        var operatorLabel = _ref2.operatorLabel,
            propertyLabel = _ref2.propertyLabel,
            type = _ref2.type,
            value = _ref2.value;
        var parsedValue = type === _constants.PROPERTY_TYPES.DATE || type === _constants.PROPERTY_TYPES.DATE_TIME ? (0, _utils.dateToInternationalHuman)(value) : value;
        return _react["default"].createElement("span", null, _react["default"].createElement("b", {
          className: "mr-1 text-dark"
        }, propertyLabel), _react["default"].createElement("span", {
          className: "mr-1 operator"
        }, operatorLabel), _react["default"].createElement("b", null, parsedValue));
      });

      _defineProperty(_assertThisInitialized(_this), "_getSelectedItem", function (list, idSelected) {
        var selectedItem = list.find(function (item) {
          return item.name === idSelected;
        });
        return selectedItem ? selectedItem : {
          label: idSelected,
          name: idSelected,
          notFound: true,
          type: _constants.PROPERTY_TYPES.STRING
        };
      });

      _defineProperty(_assertThisInitialized(_this), "_handleDelete", function (event) {
        event.preventDefault();
        var _this$props2 = _this.props,
            index = _this$props2.index,
            onDelete = _this$props2.onDelete;
        onDelete(index);
      });

      _defineProperty(_assertThisInitialized(_this), "_handleDuplicate", function (event) {
        event.preventDefault();
        var _this$props3 = _this.props,
            criterion = _this$props3.criterion,
            index = _this$props3.index,
            onAdd = _this$props3.onAdd;
        onAdd(index + 1, criterion);
      });

      _defineProperty(_assertThisInitialized(_this), "_handleInputChange", function (propertyName) {
        return function (event) {
          var _this$props4 = _this.props,
              criterion = _this$props4.criterion,
              onChange = _this$props4.onChange;
          onChange(_objectSpread({}, criterion, _defineProperty({}, propertyName, event.target.value)));
        };
      });

      _defineProperty(_assertThisInitialized(_this), "_handleTypedInputChange", function (value) {
        var _this$props5 = _this.props,
            criterion = _this$props5.criterion,
            onChange = _this$props5.onChange;

        if (Array.isArray(value)) {
          var items = value.map(function (item) {
            return _objectSpread({}, criterion, {}, item);
          });
          onChange((0, _utils.createNewGroup)(items));
        } else {
          onChange(_objectSpread({}, criterion, {}, value));
        }
      });

      _defineProperty(_assertThisInitialized(_this), "_renderValueInput", function (selectedProperty, value, disabled) {
        var _inputComponentsMap;

        var inputComponentsMap = (_inputComponentsMap = {}, _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.BOOLEAN, _BooleanInput["default"]), _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.COLLECTION, _CollectionInput["default"]), _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.DATE, _DateInput["default"]), _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.DATE_TIME, _DateTimeInput["default"]), _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.DOUBLE, _DecimalInput["default"]), _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.ID, _SelectEntityInput["default"]), _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.INTEGER, _IntegerInput["default"]), _defineProperty(_inputComponentsMap, _constants.PROPERTY_TYPES.STRING, _StringInput["default"]), _inputComponentsMap);
        var InputComponent = inputComponentsMap[selectedProperty.type] || inputComponentsMap[_constants.PROPERTY_TYPES.STRING];
        return _react["default"].createElement(InputComponent, {
          disabled: disabled,
          displayValue: _this.props.criterion.displayValue || '',
          onChange: _this._handleTypedInputChange,
          options: selectedProperty.options,
          selectEntity: selectedProperty.selectEntity,
          value: value
        });
      });

      return _this;
    }

    _createClass(CriteriaRow, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this$props6 = this.props,
            _this$props6$criterio = _this$props6.criterion,
            displayValue = _this$props6$criterio.displayValue,
            propertyName = _this$props6$criterio.propertyName,
            value = _this$props6$criterio.value,
            supportedProperties = _this$props6.supportedProperties;
        this._selectedProperty = this._getSelectedItem(supportedProperties, propertyName);

        if (this._selectedProperty.type === _constants.PROPERTY_TYPES.ID && value && !displayValue) {
          this._fetchEntityName();
        }
      }
    }, {
      key: "_renderErrorMessage",
      value: function _renderErrorMessage() {
        var editing = this.props.editing;
        var message = editing ? Liferay.Language.get('criteria-error-message-edit') : Liferay.Language.get('criteria-error-message-view');
        return _react["default"].createElement(_alert["default"], {
          className: "bg-transparent border-0 mt-1 p-1",
          displayType: "danger",
          title: Liferay.Language.get('error')
        }, message);
      }
    }, {
      key: "_renderEditContainer",
      value: function _renderEditContainer(_ref3) {
        var error = _ref3.error,
            propertyLabel = _ref3.propertyLabel,
            selectedOperator = _ref3.selectedOperator,
            selectedProperty = _ref3.selectedProperty,
            value = _ref3.value;
        var _this$props7 = this.props,
            connectDragSource = _this$props7.connectDragSource,
            supportedOperators = _this$props7.supportedOperators,
            supportedPropertyTypes = _this$props7.supportedPropertyTypes;
        var propertyType = selectedProperty ? selectedProperty.type : '';
        var filteredSupportedOperators = (0, _utils.getSupportedOperatorsFromType)(supportedOperators, supportedPropertyTypes, propertyType);
        var disabledInput = !!error;
        return _react["default"].createElement("div", {
          className: "edit-container"
        }, connectDragSource(_react["default"].createElement("div", {
          className: "drag-icon"
        }, _react["default"].createElement(_icon["default"], {
          symbol: "drag"
        }))), _react["default"].createElement("span", {
          className: "criterion-string"
        }, _react["default"].createElement("b", null, propertyLabel)), _react["default"].createElement(_form.ClaySelectWithOption, {
          className: "criterion-input form-control operator-input",
          disabled: disabledInput,
          onChange: this._handleInputChange('operatorName'),
          options: filteredSupportedOperators.map(function (_ref4) {
            var label = _ref4.label,
                name = _ref4.name;
            return {
              label: label,
              value: name
            };
          }),
          value: selectedOperator && selectedOperator.name
        }), this._renderValueInput(selectedProperty, value, disabledInput), error ? _react["default"].createElement(_button["default"], {
          className: "btn-outline-danger",
          onClick: this._handleDelete
        }, Liferay.Language.get('delete')) : _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_button["default"], {
          className: "btn-outline-borderless",
          displayType: "secondary",
          monospaced: true,
          onClick: this._handleDuplicate
        }, _react["default"].createElement(_icon["default"], {
          symbol: "paste"
        })), _react["default"].createElement(_button["default"], {
          className: "btn-outline-borderless",
          displayType: "secondary",
          monospaced: true,
          onClick: this._handleDelete
        }, _react["default"].createElement(_icon["default"], {
          symbol: "times-circle"
        }))));
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props8 = this.props,
            canDrop = _this$props8.canDrop,
            connectDragPreview = _this$props8.connectDragPreview,
            connectDropTarget = _this$props8.connectDropTarget,
            criterion = _this$props8.criterion,
            dragging = _this$props8.dragging,
            editing = _this$props8.editing,
            hover = _this$props8.hover,
            supportedOperators = _this$props8.supportedOperators,
            supportedProperties = _this$props8.supportedProperties;

        var selectedOperator = this._getSelectedItem(supportedOperators, criterion.operatorName);

        var selectedProperty = this._getSelectedItem(supportedProperties, criterion.propertyName);

        var errorOnProperty = selectedProperty.notFound;
        var operatorLabel = selectedOperator ? selectedOperator.label : '';
        var propertyLabel = selectedProperty ? selectedProperty.label : '';
        var value = criterion ? criterion.value : '';
        var classes = (0, _classnames["default"])('criterion-row-root', {
          'criterion-row-root-error': errorOnProperty,
          'dnd-drag': dragging,
          'dnd-hover': hover && canDrop
        });
        return _react["default"].createElement(_react["default"].Fragment, null, connectDropTarget(connectDragPreview(_react["default"].createElement("div", {
          className: classes
        }, editing ? this._renderEditContainer({
          error: errorOnProperty,
          propertyLabel: propertyLabel,
          selectedOperator: selectedOperator,
          selectedProperty: selectedProperty,
          value: value
        }) : _react["default"].createElement("span", {
          className: "criterion-string"
        }, this._getReadableCriteriaString({
          error: errorOnProperty,
          operatorLabel: operatorLabel,
          propertyLabel: propertyLabel,
          type: selectedProperty.type,
          value: criterion.displayValue || value
        }))))), errorOnProperty && this._renderErrorMessage());
      }
    }]);

    return CriteriaRow;
  }(_react.Component);

  _defineProperty(CriteriaRow, "contextType", _ThemeContext["default"]);

  _defineProperty(CriteriaRow, "propTypes", {
    canDrop: _propTypes.PropTypes.bool,
    connectDragPreview: _propTypes.PropTypes.func,
    connectDragSource: _propTypes.PropTypes.func,
    connectDropTarget: _propTypes.PropTypes.func,
    criterion: _propTypes.PropTypes.object,
    dragging: _propTypes.PropTypes.bool,
    editing: _propTypes.PropTypes.bool,
    entityName: _propTypes.PropTypes.string,
    groupId: _propTypes.PropTypes.string.isRequired,
    hover: _propTypes.PropTypes.bool,
    index: _propTypes.PropTypes.number.isRequired,
    modelLabel: _propTypes.PropTypes.string,
    onAdd: _propTypes.PropTypes.func.isRequired,
    onChange: _propTypes.PropTypes.func.isRequired,
    onDelete: _propTypes.PropTypes.func.isRequired,
    onMove: _propTypes.PropTypes.func.isRequired,
    propertyKey: _propTypes.PropTypes.string.isRequired,
    supportedOperators: _propTypes.PropTypes.array,
    supportedProperties: _propTypes.PropTypes.array,
    supportedPropertyTypes: _propTypes.PropTypes.object
  });

  _defineProperty(CriteriaRow, "defaultProps", {
    criterion: {},
    editing: true,
    supportedOperators: [],
    supportedProperties: [],
    supportedPropertyTypes: {}
  });

  var CriteriaRowWithDrag = (0, _reactDnd.DragSource)(_dragTypes.DragTypes.CRITERIA_ROW, {
    beginDrag: beginDrag
  }, function (connect, monitor) {
    return {
      connectDragPreview: connect.dragPreview(),
      connectDragSource: connect.dragSource(),
      dragging: monitor.isDragging()
    };
  })(CriteriaRow);

  var _default = (0, _reactDnd.DropTarget)(acceptedDragTypes, {
    canDrop: canDrop,
    drop: drop
  }, function (connect, monitor) {
    return {
      canDrop: monitor.canDrop(),
      connectDropTarget: connect.dropTarget(),
      hover: monitor.isOver()
    };
  })(CriteriaRowWithDrag);

  exports["default"] = _default;
  //# sourceMappingURL=CriteriaRow.es.js.map
});
//# sourceMappingURL=CriteriaRow.es.js.map