Liferay.Loader.define("segments-web@1.0.37/js/components/criteria_builder/CriteriaGroup.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../../utils/constants.es', '../../utils/drag-types.es', '../../utils/utils.es', './Conjunction.es', './CriteriaRow.es', './DropZone.es', './EmptyDropZone.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = require("frontend-js-react-web$prop-types");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _constants = require("../../utils/constants.es");

  var _dragTypes = require("../../utils/drag-types.es");

  var _utils = require("../../utils/utils.es");

  var _Conjunction = _interopRequireDefault(require("./Conjunction.es"));

  var _CriteriaRow = _interopRequireDefault(require("./CriteriaRow.es"));

  var _DropZone = _interopRequireDefault(require("./DropZone.es"));

  var _EmptyDropZone = _interopRequireDefault(require("./EmptyDropZone.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Passes the required values to the drop target.
   * This method must be called `beginDrag`.
   * @param {Object} props Component's current props
   * @returns {Object} The props to be passed to the drop target.
   */
  function beginDrag(_ref) {
    var criteria = _ref.criteria,
        index = _ref.index,
        parentGroupId = _ref.parentGroupId;
    var childGroupIds = (0, _utils.getChildGroupIds)(criteria);
    return {
      childGroupIds: childGroupIds,
      criterion: criteria,
      groupId: parentGroupId,
      index: index
    };
  }
  /**
   * A function that decorates the passed in component with the drag source HOC.
   * This was separated out since this function needed to be called again for the
   * nested groups.
   * @param {React.Component} component The component to decorate.
   */

  var withDragSource = (0, _reactDnd.DragSource)(_dragTypes.DragTypes.CRITERIA_GROUP, {
    beginDrag: beginDrag
  }, function (connect, monitor) {
    return {
      connectDragPreview: connect.dragPreview(),
      connectDragSource: connect.dragSource(),
      dragging: monitor.isDragging()
    };
  });

  var CriteriaGroup =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CriteriaGroup, _Component);

    function CriteriaGroup(props) {
      var _this2 = this;

      var _this;

      _classCallCheck(this, CriteriaGroup);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(CriteriaGroup).call(this, props));

      _defineProperty(_assertThisInitialized(_this), "_handleConjunctionClick", function (event) {
        event.preventDefault();
        var _this$props = _this.props,
            criteria = _this$props.criteria,
            onChange = _this$props.onChange,
            supportedConjunctions = _this$props.supportedConjunctions;
        var index = supportedConjunctions.findIndex(function (item) {
          return item.name === criteria.conjunctionName;
        });
        var conjunctionSelected = index === supportedConjunctions.length - 1 ? supportedConjunctions[0].name : supportedConjunctions[index + 1].name;
        onChange(_objectSpread({}, criteria, {
          conjunctionName: conjunctionSelected
        }));
      });

      _defineProperty(_assertThisInitialized(_this), "_handleCriterionAdd", function (index, criterion) {
        var _this$props2 = _this.props,
            criteria = _this$props2.criteria,
            onChange = _this$props2.onChange,
            root = _this$props2.root,
            supportedOperators = _this$props2.supportedOperators,
            supportedPropertyTypes = _this$props2.supportedPropertyTypes;
        var defaultValue = criterion.defaultValue,
            operatorName = criterion.operatorName,
            propertyName = criterion.propertyName,
            type = criterion.type,
            value = criterion.value;

        var operators = (0, _utils.getSupportedOperatorsFromType)(supportedOperators, supportedPropertyTypes, type);
        var newCriterion = {
          operatorName: operatorName ? operatorName : operators[0].name,
          propertyName: propertyName,
          type: type,
          value: value || defaultValue
        };

        if (root && !criteria) {
          onChange({
            conjunctionName: _constants.CONJUNCTIONS.AND,
            groupId: (0, _utils.generateGroupId)(),
            items: [newCriterion]
          });
        } else {
          onChange(_objectSpread({}, criteria, {
            items: (0, _utils.insertAtIndex)(newCriterion, criteria.items, index)
          }));
        }
      });

      _defineProperty(_assertThisInitialized(_this), "_handleCriterionChange", function (index) {
        return function (newCriterion) {
          var _this$props3 = _this.props,
              criteria = _this$props3.criteria,
              onChange = _this$props3.onChange;
          onChange(_objectSpread({}, criteria, {
            items: (0, _utils.replaceAtIndex)(newCriterion, criteria.items, index)
          }));
        };
      });

      _defineProperty(_assertThisInitialized(_this), "_handleCriterionDelete", function (index) {
        var _this$props4 = _this.props,
            criteria = _this$props4.criteria,
            onChange = _this$props4.onChange;
        onChange(_objectSpread({}, criteria, {
          items: criteria.items.filter(function (fItem, fIndex) {
            return fIndex !== index;
          })
        }));
      });

      _defineProperty(_assertThisInitialized(_this), "_isCriteriaEmpty", function () {
        var criteria = _this.props.criteria;
        return criteria ? !criteria.items.length : true;
      });

      _defineProperty(_assertThisInitialized(_this), "_renderConjunction", function (index) {
        var _this$props5 = _this.props,
            criteria = _this$props5.criteria,
            editing = _this$props5.editing,
            groupId = _this$props5.groupId,
            onMove = _this$props5.onMove,
            propertyKey = _this$props5.propertyKey,
            supportedConjunctions = _this$props5.supportedConjunctions;
        return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_DropZone["default"], {
          dropIndex: index,
          groupId: groupId,
          onCriterionAdd: _this._handleCriterionAdd,
          onMove: onMove,
          propertyKey: propertyKey
        }), _react["default"].createElement(_Conjunction["default"], {
          conjunctionName: criteria.conjunctionName,
          editing: editing,
          onClick: _this._handleConjunctionClick,
          supportedConjunctions: supportedConjunctions
        }), _react["default"].createElement(_DropZone["default"], {
          before: true,
          dropIndex: index,
          groupId: groupId,
          onCriterionAdd: _this._handleCriterionAdd,
          onMove: onMove,
          propertyKey: propertyKey
        }));
      });

      _defineProperty(_assertThisInitialized(_this), "_renderCriterion", function (criterion, index) {
        var _this$props6 = _this.props,
            editing = _this$props6.editing,
            entityName = _this$props6.entityName,
            groupId = _this$props6.groupId,
            modelLabel = _this$props6.modelLabel,
            onMove = _this$props6.onMove,
            propertyKey = _this$props6.propertyKey,
            root = _this$props6.root,
            supportedConjunctions = _this$props6.supportedConjunctions,
            supportedOperators = _this$props6.supportedOperators,
            supportedProperties = _this$props6.supportedProperties,
            supportedPropertyTypes = _this$props6.supportedPropertyTypes;
        var classes = (0, _classnames["default"])('criterion', {
          'criterion-group': criterion.items
        });
        return _react["default"].createElement("div", {
          className: classes
        }, criterion.items ? _react["default"].createElement(_this2.NestedCriteriaGroupWithDrag, {
          criteria: criterion,
          editing: editing,
          entityName: entityName,
          groupId: criterion.groupId,
          index: index,
          modelLabel: modelLabel,
          onChange: _this._handleCriterionChange(index),
          onMove: onMove,
          parentGroupId: groupId,
          propertyKey: propertyKey,
          supportedConjunctions: supportedConjunctions,
          supportedOperators: supportedOperators,
          supportedProperties: supportedProperties,
          supportedPropertyTypes: supportedPropertyTypes
        }) : _react["default"].createElement(_CriteriaRow["default"], {
          criterion: criterion,
          editing: editing,
          entityName: entityName,
          groupId: groupId,
          index: index,
          modelLabel: modelLabel,
          onAdd: _this._handleCriterionAdd,
          onChange: _this._handleCriterionChange(index),
          onDelete: _this._handleCriterionDelete,
          onMove: onMove,
          propertyKey: propertyKey,
          root: root,
          supportedOperators: supportedOperators,
          supportedProperties: supportedProperties,
          supportedPropertyTypes: supportedPropertyTypes
        }), _react["default"].createElement(_DropZone["default"], {
          dropIndex: index + 1,
          groupId: groupId,
          onCriterionAdd: _this._handleCriterionAdd,
          onMove: onMove,
          propertyKey: propertyKey
        }));
      });

      _this.NestedCriteriaGroupWithDrag = withDragSource(CriteriaGroup);
      return _this;
    }

    _createClass(CriteriaGroup, [{
      key: "render",
      value: function render() {
        var _this3 = this;

        var _this$props7 = this.props,
            connectDragPreview = _this$props7.connectDragPreview,
            connectDragSource = _this$props7.connectDragSource,
            criteria = _this$props7.criteria,
            dragging = _this$props7.dragging,
            editing = _this$props7.editing,
            emptyContributors = _this$props7.emptyContributors,
            groupId = _this$props7.groupId,
            onMove = _this$props7.onMove,
            propertyKey = _this$props7.propertyKey,
            root = _this$props7.root;
        var classes = (0, _classnames["default"])({
          'criteria-group-root': criteria
        }, "criteria-group-item".concat(root ? '-root' : ''), "color--".concat(propertyKey), {
          'dnd-drag': dragging
        });
        var singleRow = criteria && criteria.items && criteria.items.length === 1;
        return connectDragPreview(_react["default"].createElement("div", {
          className: classes
        }, this._isCriteriaEmpty() ? _react["default"].createElement(_EmptyDropZone["default"], {
          emptyContributors: emptyContributors,
          onCriterionAdd: this._handleCriterionAdd,
          propertyKey: propertyKey
        }) : _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_DropZone["default"], {
          before: true,
          dropIndex: 0,
          groupId: groupId,
          onCriterionAdd: this._handleCriterionAdd,
          onMove: onMove,
          propertyKey: propertyKey
        }), editing && singleRow && !root && connectDragSource(_react["default"].createElement("div", {
          className: "criteria-group-drag-icon drag-icon"
        }, _react["default"].createElement(_icon["default"], {
          symbol: "drag"
        }))), criteria.items && criteria.items.map(function (criterion, index) {
          return _react["default"].createElement(_react.Fragment, {
            key: index
          }, index !== 0 && _this3._renderConjunction(index), _this3._renderCriterion(criterion, index));
        }))));
      }
    }]);

    return CriteriaGroup;
  }(_react.Component);

  _defineProperty(CriteriaGroup, "propTypes", {
    connectDragPreview: _propTypes.PropTypes.func,
    connectDragSource: _propTypes.PropTypes.func,
    criteria: _propTypes.PropTypes.object,
    dragging: _propTypes.PropTypes.bool,
    editing: _propTypes.PropTypes.bool,
    emptyContributors: _propTypes.PropTypes.bool,
    entityName: _propTypes.PropTypes.string,
    groupId: _propTypes.PropTypes.string,
    index: _propTypes.PropTypes.number,
    modelLabel: _propTypes.PropTypes.string,
    onChange: _propTypes.PropTypes.func,
    onMove: _propTypes.PropTypes.func,
    parentGroupId: _propTypes.PropTypes.string,
    propertyKey: _propTypes.PropTypes.string.isRequired,
    root: _propTypes.PropTypes.bool,
    supportedConjunctions: _propTypes.PropTypes.array,
    supportedOperators: _propTypes.PropTypes.array,
    supportedProperties: _propTypes.PropTypes.array,
    supportedPropertyTypes: _propTypes.PropTypes.object
  });

  _defineProperty(CriteriaGroup, "defaultProps", {
    root: false
  });

  var _default = withDragSource(CriteriaGroup);

  exports["default"] = _default;
  //# sourceMappingURL=CriteriaGroup.es.js.map
});
//# sourceMappingURL=CriteriaGroup.es.js.map