/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.item.selector.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.SearchOrderByUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.segments.item.selector.criterion.SegmentsEntryItemSelectorCriterion;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class SegmentsEntryDisplayContext {
    private long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final PortletURL _portletURL;
    private final RenderRequest _renderRequest;
    private SearchContainer<SegmentsEntry> _segmentEntrySearchContainer;
    private final SegmentsEntryItemSelectorCriterion _segmentsEntryItemSelectorCriterion;
    private final SegmentsEntryLocalService _segmentsEntryLocalService;
    private final ThemeDisplay _themeDisplay;

    public SegmentsEntryDisplayContext(HttpServletRequest httpServletRequest, PortletURL portletURL, RenderRequest renderRequest, SegmentsEntryItemSelectorCriterion segmentsEntryItemSelectorCriterion, SegmentsEntryLocalService segmentsEntryLocalService) {
        this._httpServletRequest = httpServletRequest;
        this._portletURL = portletURL;
        this._renderRequest = renderRequest;
        this._segmentsEntryItemSelectorCriterion = segmentsEntryItemSelectorCriterion;
        this._segmentsEntryLocalService = segmentsEntryLocalService;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public SearchContainer<SegmentsEntry> getSegmentEntrySearchContainer() throws PortalException {
        if (this._segmentEntrySearchContainer != null) {
            return this._segmentEntrySearchContainer;
        }
        SearchContainer segmentEntrySearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._portletURL, null, "there-are-no-segments");
        segmentEntrySearchContainer.setOrderByCol(this._getOrderByCol());
        segmentEntrySearchContainer.setOrderByType(this._getOrderByType());
        segmentEntrySearchContainer.setResultsAndTotal(this._segmentsEntryLocalService.searchSegmentsEntries(this._themeDisplay.getCompanyId(), this._getGroupId(), this._getKeywords(), LinkedHashMapBuilder.put((Object)"excludedSegmentsEntryIds", (Object)this._segmentsEntryItemSelectorCriterion.getExcludedSegmentsEntryIds()).put((Object)"excludedSources", (Object)this._segmentsEntryItemSelectorCriterion.getExcludedSources()).build(), segmentEntrySearchContainer.getStart(), segmentEntrySearchContainer.getEnd(), this._getSort()));
        this._segmentEntrySearchContainer = segmentEntrySearchContainer;
        return this._segmentEntrySearchContainer;
    }

    private long _getGroupId() {
        if (this._groupId > 0L) {
            return this._groupId;
        }
        long groupId = this._segmentsEntryItemSelectorCriterion.getGroupId();
        if (groupId == 0L) {
            groupId = this._themeDisplay.getScopeGroupId();
        }
        this._groupId = groupId;
        return this._groupId;
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    private String _getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = SearchOrderByUtil.getOrderByCol((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_segments_web_internal_portlet_SegmentsPortlet", (String)"entry-order-by-col", (String)"modified-date");
        return this._orderByCol;
    }

    private String _getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = SearchOrderByUtil.getOrderByType((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_segments_web_internal_portlet_SegmentsPortlet", (String)"entry-order-by-type", (String)"asc");
        return this._orderByType;
    }

    private Sort _getSort() {
        boolean orderByAsc = false;
        if (Objects.equals(this._getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        if (Objects.equals(this._getOrderByCol(), "name")) {
            return new Sort(Field.getSortableFieldName((String)"localized_name_".concat(this._themeDisplay.getLanguageId())), 3, !orderByAsc);
        }
        return new Sort("modified", 6, !orderByAsc);
    }
}

