/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.demo.internal;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.segments.demo.data.creator.SegmentsEntryDemoDataCreator;
import com.liferay.site.demo.data.creator.SiteDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.SiteAdminUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.SiteMemberUserDemoDataCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class SegmentsDemo
extends BasePortalInstanceLifecycleListener {
    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private SegmentsEntryDemoDataCreator _segmentsEntryDemoDataCreator;
    @Reference
    private SiteAdminUserDemoDataCreator _siteAdminUserDemoDataCreator;
    @Reference
    private SiteDemoDataCreator _siteDemoDataCreator;
    @Reference
    private SiteMemberUserDemoDataCreator _siteMemberUserDemoDataCreator;

    public void portalInstanceRegistered(Company company) throws Exception {
        Group group = this._siteDemoDataCreator.create(company.getCompanyId(), "Segments Demo Site");
        for (int i = 0; i < 30; ++i) {
            this._siteMemberUserDemoDataCreator.create(group.getGroupId());
        }
        User user = this._siteAdminUserDemoDataCreator.create(group.getGroupId(), "segments.admin@liferay.com");
        for (int i = 0; i < 5; ++i) {
            this._segmentsEntryDemoDataCreator.create(user.getUserId(), group.getGroupId());
        }
    }

    @Deactivate
    protected void deactivate() throws PortalException {
        this._segmentsEntryDemoDataCreator.delete();
        this._siteMemberUserDemoDataCreator.delete();
        this._siteAdminUserDemoDataCreator.delete();
        this._siteDemoDataCreator.delete();
    }
}

