/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.rest.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import com.liferay.segments.asah.rest.dto.v1_0.ExperimentVariant;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="ExperimentRun")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"confidenceLevel", "experimentVariants"})
@XmlRootElement(name="ExperimentRun")
public class ExperimentRun
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Double confidenceLevel;
    @JsonIgnore
    private Supplier<Double> _confidenceLevelSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected ExperimentVariant[] experimentVariants;
    @JsonIgnore
    private Supplier<ExperimentVariant[]> _experimentVariantsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String status;
    @JsonIgnore
    private Supplier<String> _statusSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.segments.asah.rest.dto.v1_0.ExperimentRun", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static ExperimentRun toDTO(String json) {
        return (ExperimentRun)ObjectMapperUtil.readValue(ExperimentRun.class, (String)json);
    }

    public static ExperimentRun unsafeToDTO(String json) {
        return (ExperimentRun)ObjectMapperUtil.unsafeReadValue(ExperimentRun.class, (String)json);
    }

    @DecimalMax(value="99")
    @DecimalMin(value="80")
    @Schema
    public @DecimalMax(value="99") @DecimalMin(value="80") Double getConfidenceLevel() {
        if (this._confidenceLevelSupplier != null) {
            this.confidenceLevel = this._confidenceLevelSupplier.get();
            this._confidenceLevelSupplier = null;
        }
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(Double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        this._confidenceLevelSupplier = null;
    }

    @JsonIgnore
    public void setConfidenceLevel(UnsafeSupplier<Double, Exception> confidenceLevelUnsafeSupplier) {
        this._confidenceLevelSupplier = () -> {
            try {
                return (Double)confidenceLevelUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public ExperimentVariant[] getExperimentVariants() {
        if (this._experimentVariantsSupplier != null) {
            this.experimentVariants = this._experimentVariantsSupplier.get();
            this._experimentVariantsSupplier = null;
        }
        return this.experimentVariants;
    }

    public void setExperimentVariants(ExperimentVariant[] experimentVariants) {
        this.experimentVariants = experimentVariants;
        this._experimentVariantsSupplier = null;
    }

    @JsonIgnore
    public void setExperimentVariants(UnsafeSupplier<ExperimentVariant[], Exception> experimentVariantsUnsafeSupplier) {
        this._experimentVariantsSupplier = () -> {
            try {
                return (ExperimentVariant[])experimentVariantsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getStatus() {
        if (this._statusSupplier != null) {
            this.status = this._statusSupplier.get();
            this._statusSupplier = null;
        }
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        this._statusSupplier = null;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<String, Exception> statusUnsafeSupplier) {
        this._statusSupplier = () -> {
            try {
                return (String)statusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExperimentRun)) {
            return false;
        }
        ExperimentRun experimentRun = (ExperimentRun)object;
        return Objects.equals(this.toString(), experimentRun.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String status;
        ExperimentVariant[] experimentVariants;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Double confidenceLevel = this.getConfidenceLevel();
        if (confidenceLevel != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"confidenceLevel\": ");
            sb.append((Object)confidenceLevel);
        }
        if ((experimentVariants = this.getExperimentVariants()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"experimentVariants\": ");
            sb.append("[");
            for (int i = 0; i < experimentVariants.length; ++i) {
                sb.append(String.valueOf(experimentVariants[i]));
                if (i + 1 >= experimentVariants.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((status = this.getStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append("\"");
            sb.append(ExperimentRun._escape(status));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(ExperimentRun._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (ExperimentRun._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(ExperimentRun._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ExperimentRun._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ExperimentRun._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

