/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.segments.field.customizer;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.segments.field.Field;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.portlet.PortletRequest;

/**
 * Provides an interface for customizing a {@link Field}.
 *
 * @author Eduardo García
 */
public interface SegmentsFieldCustomizer {

	public default ClassedModel getClassedModel(String fieldValue) {
		return null;
	}

	public default String getClassName() {
		return null;
	}

	public List<String> getFieldNames();

	public default String getFieldValueName(String fieldValue, Locale locale) {
		return fieldValue;
	}

	public default String getIcon() {
		return null;
	}

	public String getKey();

	public default String getLabel(String fieldName, Locale locale) {
		ResourceBundle resourceBundle = ResourceBundleUtil.getBundle(
			"content.Language", locale, getClass());

		return LanguageUtil.get(
			resourceBundle, "field." + CamelCaseUtil.fromCamelCase(fieldName));
	}

	public default List<Field.Option> getOptions(Locale locale) {
		return Collections.emptyList();
	}

	public default Field.SelectEntity getSelectEntity(
		PortletRequest portletRequest) {

		return null;
	}

}