/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.rest.dto.v1_0.util;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.search.experiences.rest.dto.v1_0.AggregationConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.Clause;
import com.liferay.search.experiences.rest.dto.v1_0.Condition;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.QueryConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.Rescore;
import com.liferay.search.experiences.rest.dto.v1_0.SortConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.util.ConditionUtil;
import com.liferay.search.experiences.rest.dto.v1_0.util.UnpackUtil;

public class ConfigurationUtil {
    public static Configuration toConfiguration(String json) {
        if (Validator.isNull((String)json)) {
            return null;
        }
        return ConfigurationUtil.unpack(Configuration.unsafeToDTO(json));
    }

    protected static Configuration unpack(Configuration configuration) {
        SortConfiguration sortConfiguration;
        QueryConfiguration queryConfiguration;
        if (configuration == null) {
            return null;
        }
        AggregationConfiguration aggregationConfiguration = configuration.getAggregationConfiguration();
        if (aggregationConfiguration != null) {
            Object aggs = aggregationConfiguration.getAggs();
            aggregationConfiguration.setAggs((UnsafeSupplier<Object, Exception>)((UnsafeSupplier)() -> UnpackUtil.unpack(aggs)));
        }
        if ((queryConfiguration = configuration.getQueryConfiguration()) != null) {
            ArrayUtil.isNotEmptyForEach((Object[])queryConfiguration.getQueryEntries(), queryEntry -> {
                ArrayUtil.isNotEmptyForEach((Object[])queryEntry.getClauses(), ConfigurationUtil::_unpack);
                ArrayUtil.isNotEmptyForEach((Object[])queryEntry.getPostFilterClauses(), ConfigurationUtil::_unpack);
                ArrayUtil.isNotEmptyForEach((Object[])queryEntry.getRescores(), ConfigurationUtil::_unpack);
                Condition condition = queryEntry.getCondition();
                if (condition != null) {
                    queryEntry.setCondition((UnsafeSupplier<Condition, Exception>)((UnsafeSupplier)() -> ConditionUtil.unpack(condition)));
                }
            });
        }
        if ((sortConfiguration = configuration.getSortConfiguration()) != null) {
            Object sorts = sortConfiguration.getSorts();
            sortConfiguration.setSorts((UnsafeSupplier<Object, Exception>)((UnsafeSupplier)() -> UnpackUtil.unpack(sorts)));
        }
        return configuration;
    }

    private static void _unpack(Clause clause) {
        if (clause == null) {
            return;
        }
        Object query = clause.getQuery();
        clause.setQuery((UnsafeSupplier<Object, Exception>)((UnsafeSupplier)() -> UnpackUtil.unpack(query)));
    }

    private static void _unpack(Rescore rescore) {
        if (rescore == null) {
            return;
        }
        Object query = rescore.getQuery();
        rescore.setQuery((UnsafeSupplier<Object, Exception>)((UnsafeSupplier)() -> UnpackUtil.unpack(query)));
    }
}

