/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import com.liferay.scim.rest.dto.v1_0.Meta;
import com.liferay.scim.rest.dto.v1_0.MultiValuedAttribute;
import com.liferay.scim.rest.dto.v1_0.Name;
import com.liferay.scim.rest.dto.v1_0.UserSchemaExtension;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="User")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="User")
public class User
implements Serializable {
    @GraphQLField(description="A Boolean value indicating the user's administrative status.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A Boolean value indicating the user's administrative status.") Boolean active;
    @JsonIgnore
    private Supplier<Boolean> _activeSupplier;
    @GraphQLField(description="A physical mailing address for this user.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A physical mailing address for this user.") Object[] addresses;
    @JsonIgnore
    private Supplier<Object[]> _addressesSupplier;
    @GraphQLField(description="The name of the user, suitable for display to end-users.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The name of the user, suitable for display to end-users.") String displayName;
    @JsonIgnore
    private Supplier<String> _displayNameSupplier;
    @GraphQLField(description="Email addresses for the User.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Email addresses for the User.") MultiValuedAttribute[] emails;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _emailsSupplier;
    @GraphQLField(description="A list of entitlements for the user that represent a thing the user has.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of entitlements for the user that represent a thing the user has.") MultiValuedAttribute[] entitlements;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _entitlementsSupplier;
    @GraphQLField(description="A String that is an identifier for the resource as defined by the provisioning client.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A String that is an identifier for the resource as defined by the provisioning client.") String externalId;
    @JsonIgnore
    private Supplier<String> _externalIdSupplier;
    @GraphQLField(description="A list of groups to which the user belongs, either through direct membership, through nested groups, or dynamically calculated.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of groups to which the user belongs, either through direct membership, through nested groups, or dynamically calculated.") MultiValuedAttribute[] groups;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _groupsSupplier;
    @GraphQLField(description="A unique identifier for a SCIM resource as defined by the service provider.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A unique identifier for a SCIM resource as defined by the service provider.") String id;
    @JsonIgnore
    private Supplier<String> _idSupplier;
    @GraphQLField(description="Instant messaging address for the user.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Instant messaging address for the user.") MultiValuedAttribute[] ims;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _imsSupplier;
    @GraphQLField(description="Used to indicate the User's default location for purposes of localizing such items as currency, date time format, or numerical representations.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Used to indicate the User's default location for purposes of localizing such items as currency, date time format, or numerical representations.") String locale;
    @JsonIgnore
    private Supplier<String> _localeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Meta meta;
    @JsonIgnore
    private Supplier<Meta> _metaSupplier;
    @GraphQLField(description="The components of the user's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The components of the user's name.") Name name;
    @JsonIgnore
    private Supplier<Name> _nameSupplier;
    @GraphQLField(description="The casual way to address the user in real life, e.g., \"Bob\" or \"Bobby\" instead of \"Robert\".")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The casual way to address the user in real life, e.g., \"Bob\" or \"Bobby\" instead of \"Robert\".") String nickName;
    @JsonIgnore
    private Supplier<String> _nickNameSupplier;
    @GraphQLField(description="This attribute is intended to be used as a means to set, replace, or compare (i.e., filter for equality) a password.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="This attribute is intended to be used as a means to set, replace, or compare (i.e., filter for equality) a password.") String password;
    @JsonIgnore
    private Supplier<String> _passwordSupplier;
    @GraphQLField(description="Phone numbers for the user.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Phone numbers for the user.") MultiValuedAttribute[] phoneNumbers;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _phoneNumbersSupplier;
    @GraphQLField(description="A URI that is a uniform resource locator that points to a resource location representing the user's image.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A URI that is a uniform resource locator that points to a resource location representing the user's image.") MultiValuedAttribute[] photos;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _photosSupplier;
    @GraphQLField(description="Indicates the user's preferred written or spoken languages and is generally used for selecting a localized user interface.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Indicates the user's preferred written or spoken languages and is generally used for selecting a localized user interface.") String preferredLanguage;
    @JsonIgnore
    private Supplier<String> _preferredLanguageSupplier;
    @GraphQLField(description="A URI that is a uniform resource locator and that points to a location representing the user's online profile (e.g., a web page).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A URI that is a uniform resource locator and that points to a location representing the user's online profile (e.g., a web page).") String profileUrl;
    @JsonIgnore
    private Supplier<String> _profileUrlSupplier;
    @GraphQLField(description="A list of roles for the user that collectively represent who the user is, e.g., \"Student\", \"Faculty\".")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of roles for the user that collectively represent who the user is, e.g., \"Student\", \"Faculty\".") MultiValuedAttribute[] roles;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _rolesSupplier;
    @GraphQLField(description="A multi-valued list of strings indicating the namespaces of the SCIM schemas that define the attributes present in the current JSON structure.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A multi-valued list of strings indicating the namespaces of the SCIM schemas that define the attributes present in the current JSON structure.") String[] schemas;
    @JsonIgnore
    private Supplier<String[]> _schemasSupplier;
    @GraphQLField(description="The User's time zone, in IANA Time Zone database format, also known as the \"Olson\" time zone database format (e.g., \"America/Los_Angeles\").")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The User's time zone, in IANA Time Zone database format, also known as the \"Olson\" time zone database format (e.g., \"America/Los_Angeles\").") String timezone;
    @JsonIgnore
    private Supplier<String> _timezoneSupplier;
    @GraphQLField(description="The user's title, such as \"Vice President\".")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The user's title, such as \"Vice President\".") String title;
    @JsonIgnore
    private Supplier<String> _titleSupplier;
    @GraphQLField(description="The components of the Liferay's User Schema Extension.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE, value="urn:ietf:params:scim:schemas:extension:liferay:2.0:User")
    protected @GraphQLField(description="The components of the Liferay's User Schema Extension.") UserSchemaExtension urn_ietf_params_scim_schemas_extension_liferay_2_0_User;
    @JsonIgnore
    private Supplier<UserSchemaExtension> _urn_ietf_params_scim_schemas_extension_liferay_2_0_UserSupplier;
    @GraphQLField(description="A service provider's unique identifier for the user, typically used by the user to directly authenticate to the service provider.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A service provider's unique identifier for the user, typically used by the user to directly authenticate to the service provider.") String userName;
    @JsonIgnore
    private Supplier<String> _userNameSupplier;
    @GraphQLField(description="Used to identify the relationship between the organization and the user.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Used to identify the relationship between the organization and the user.") String userType;
    @JsonIgnore
    private Supplier<String> _userTypeSupplier;
    @GraphQLField(description="A list of certificates associated with the resource (e.g., a User).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of certificates associated with the resource (e.g., a User).") MultiValuedAttribute[] x509Certificates;
    @JsonIgnore
    private Supplier<MultiValuedAttribute[]> _x509CertificatesSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.scim.rest.dto.v1_0.User", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static User toDTO(String json) {
        return (User)ObjectMapperUtil.readValue(User.class, (String)json);
    }

    public static User unsafeToDTO(String json) {
        return (User)ObjectMapperUtil.unsafeReadValue(User.class, (String)json);
    }

    @Schema(description="A Boolean value indicating the user's administrative status.")
    public Boolean getActive() {
        if (this._activeSupplier != null) {
            this.active = this._activeSupplier.get();
            this._activeSupplier = null;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
        this._activeSupplier = null;
    }

    @JsonIgnore
    public void setActive(UnsafeSupplier<Boolean, Exception> activeUnsafeSupplier) {
        this._activeSupplier = () -> {
            try {
                return (Boolean)activeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A physical mailing address for this user.")
    @Valid
    public Object[] getAddresses() {
        if (this._addressesSupplier != null) {
            this.addresses = this._addressesSupplier.get();
            this._addressesSupplier = null;
        }
        return this.addresses;
    }

    public void setAddresses(Object[] addresses) {
        this.addresses = addresses;
        this._addressesSupplier = null;
    }

    @JsonIgnore
    public void setAddresses(UnsafeSupplier<Object[], Exception> addressesUnsafeSupplier) {
        this._addressesSupplier = () -> {
            try {
                return (Object[])addressesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The name of the user, suitable for display to end-users.")
    public String getDisplayName() {
        if (this._displayNameSupplier != null) {
            this.displayName = this._displayNameSupplier.get();
            this._displayNameSupplier = null;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this._displayNameSupplier = null;
    }

    @JsonIgnore
    public void setDisplayName(UnsafeSupplier<String, Exception> displayNameUnsafeSupplier) {
        this._displayNameSupplier = () -> {
            try {
                return (String)displayNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Email addresses for the User.")
    @Valid
    public MultiValuedAttribute[] getEmails() {
        if (this._emailsSupplier != null) {
            this.emails = this._emailsSupplier.get();
            this._emailsSupplier = null;
        }
        return this.emails;
    }

    public void setEmails(MultiValuedAttribute[] emails) {
        this.emails = emails;
        this._emailsSupplier = null;
    }

    @JsonIgnore
    public void setEmails(UnsafeSupplier<MultiValuedAttribute[], Exception> emailsUnsafeSupplier) {
        this._emailsSupplier = () -> {
            try {
                return (MultiValuedAttribute[])emailsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of entitlements for the user that represent a thing the user has.")
    @Valid
    public MultiValuedAttribute[] getEntitlements() {
        if (this._entitlementsSupplier != null) {
            this.entitlements = this._entitlementsSupplier.get();
            this._entitlementsSupplier = null;
        }
        return this.entitlements;
    }

    public void setEntitlements(MultiValuedAttribute[] entitlements) {
        this.entitlements = entitlements;
        this._entitlementsSupplier = null;
    }

    @JsonIgnore
    public void setEntitlements(UnsafeSupplier<MultiValuedAttribute[], Exception> entitlementsUnsafeSupplier) {
        this._entitlementsSupplier = () -> {
            try {
                return (MultiValuedAttribute[])entitlementsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A String that is an identifier for the resource as defined by the provisioning client.")
    public String getExternalId() {
        if (this._externalIdSupplier != null) {
            this.externalId = this._externalIdSupplier.get();
            this._externalIdSupplier = null;
        }
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
        this._externalIdSupplier = null;
    }

    @JsonIgnore
    public void setExternalId(UnsafeSupplier<String, Exception> externalIdUnsafeSupplier) {
        this._externalIdSupplier = () -> {
            try {
                return (String)externalIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of groups to which the user belongs, either through direct membership, through nested groups, or dynamically calculated.")
    @Valid
    public MultiValuedAttribute[] getGroups() {
        if (this._groupsSupplier != null) {
            this.groups = this._groupsSupplier.get();
            this._groupsSupplier = null;
        }
        return this.groups;
    }

    public void setGroups(MultiValuedAttribute[] groups) {
        this.groups = groups;
        this._groupsSupplier = null;
    }

    @JsonIgnore
    public void setGroups(UnsafeSupplier<MultiValuedAttribute[], Exception> groupsUnsafeSupplier) {
        this._groupsSupplier = () -> {
            try {
                return (MultiValuedAttribute[])groupsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A unique identifier for a SCIM resource as defined by the service provider.")
    public String getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<String, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (String)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Instant messaging address for the user.")
    @Valid
    public MultiValuedAttribute[] getIms() {
        if (this._imsSupplier != null) {
            this.ims = this._imsSupplier.get();
            this._imsSupplier = null;
        }
        return this.ims;
    }

    public void setIms(MultiValuedAttribute[] ims) {
        this.ims = ims;
        this._imsSupplier = null;
    }

    @JsonIgnore
    public void setIms(UnsafeSupplier<MultiValuedAttribute[], Exception> imsUnsafeSupplier) {
        this._imsSupplier = () -> {
            try {
                return (MultiValuedAttribute[])imsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Used to indicate the User's default location for purposes of localizing such items as currency, date time format, or numerical representations.")
    public String getLocale() {
        if (this._localeSupplier != null) {
            this.locale = this._localeSupplier.get();
            this._localeSupplier = null;
        }
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
        this._localeSupplier = null;
    }

    @JsonIgnore
    public void setLocale(UnsafeSupplier<String, Exception> localeUnsafeSupplier) {
        this._localeSupplier = () -> {
            try {
                return (String)localeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Meta getMeta() {
        if (this._metaSupplier != null) {
            this.meta = this._metaSupplier.get();
            this._metaSupplier = null;
        }
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
        this._metaSupplier = null;
    }

    @JsonIgnore
    public void setMeta(UnsafeSupplier<Meta, Exception> metaUnsafeSupplier) {
        this._metaSupplier = () -> {
            try {
                return (Meta)metaUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The components of the user's name.")
    @Valid
    public Name getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<Name, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (Name)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The casual way to address the user in real life, e.g., \"Bob\" or \"Bobby\" instead of \"Robert\".")
    public String getNickName() {
        if (this._nickNameSupplier != null) {
            this.nickName = this._nickNameSupplier.get();
            this._nickNameSupplier = null;
        }
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
        this._nickNameSupplier = null;
    }

    @JsonIgnore
    public void setNickName(UnsafeSupplier<String, Exception> nickNameUnsafeSupplier) {
        this._nickNameSupplier = () -> {
            try {
                return (String)nickNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="This attribute is intended to be used as a means to set, replace, or compare (i.e., filter for equality) a password.")
    public String getPassword() {
        if (this._passwordSupplier != null) {
            this.password = this._passwordSupplier.get();
            this._passwordSupplier = null;
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this._passwordSupplier = null;
    }

    @JsonIgnore
    public void setPassword(UnsafeSupplier<String, Exception> passwordUnsafeSupplier) {
        this._passwordSupplier = () -> {
            try {
                return (String)passwordUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Phone numbers for the user.")
    @Valid
    public MultiValuedAttribute[] getPhoneNumbers() {
        if (this._phoneNumbersSupplier != null) {
            this.phoneNumbers = this._phoneNumbersSupplier.get();
            this._phoneNumbersSupplier = null;
        }
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(MultiValuedAttribute[] phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        this._phoneNumbersSupplier = null;
    }

    @JsonIgnore
    public void setPhoneNumbers(UnsafeSupplier<MultiValuedAttribute[], Exception> phoneNumbersUnsafeSupplier) {
        this._phoneNumbersSupplier = () -> {
            try {
                return (MultiValuedAttribute[])phoneNumbersUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A URI that is a uniform resource locator that points to a resource location representing the user's image.")
    @Valid
    public MultiValuedAttribute[] getPhotos() {
        if (this._photosSupplier != null) {
            this.photos = this._photosSupplier.get();
            this._photosSupplier = null;
        }
        return this.photos;
    }

    public void setPhotos(MultiValuedAttribute[] photos) {
        this.photos = photos;
        this._photosSupplier = null;
    }

    @JsonIgnore
    public void setPhotos(UnsafeSupplier<MultiValuedAttribute[], Exception> photosUnsafeSupplier) {
        this._photosSupplier = () -> {
            try {
                return (MultiValuedAttribute[])photosUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Indicates the user's preferred written or spoken languages and is generally used for selecting a localized user interface.")
    public String getPreferredLanguage() {
        if (this._preferredLanguageSupplier != null) {
            this.preferredLanguage = this._preferredLanguageSupplier.get();
            this._preferredLanguageSupplier = null;
        }
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        this._preferredLanguageSupplier = null;
    }

    @JsonIgnore
    public void setPreferredLanguage(UnsafeSupplier<String, Exception> preferredLanguageUnsafeSupplier) {
        this._preferredLanguageSupplier = () -> {
            try {
                return (String)preferredLanguageUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A URI that is a uniform resource locator and that points to a location representing the user's online profile (e.g., a web page).")
    public String getProfileUrl() {
        if (this._profileUrlSupplier != null) {
            this.profileUrl = this._profileUrlSupplier.get();
            this._profileUrlSupplier = null;
        }
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
        this._profileUrlSupplier = null;
    }

    @JsonIgnore
    public void setProfileUrl(UnsafeSupplier<String, Exception> profileUrlUnsafeSupplier) {
        this._profileUrlSupplier = () -> {
            try {
                return (String)profileUrlUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of roles for the user that collectively represent who the user is, e.g., \"Student\", \"Faculty\".")
    @Valid
    public MultiValuedAttribute[] getRoles() {
        if (this._rolesSupplier != null) {
            this.roles = this._rolesSupplier.get();
            this._rolesSupplier = null;
        }
        return this.roles;
    }

    public void setRoles(MultiValuedAttribute[] roles) {
        this.roles = roles;
        this._rolesSupplier = null;
    }

    @JsonIgnore
    public void setRoles(UnsafeSupplier<MultiValuedAttribute[], Exception> rolesUnsafeSupplier) {
        this._rolesSupplier = () -> {
            try {
                return (MultiValuedAttribute[])rolesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A multi-valued list of strings indicating the namespaces of the SCIM schemas that define the attributes present in the current JSON structure.")
    public String[] getSchemas() {
        if (this._schemasSupplier != null) {
            this.schemas = this._schemasSupplier.get();
            this._schemasSupplier = null;
        }
        return this.schemas;
    }

    public void setSchemas(String[] schemas) {
        this.schemas = schemas;
        this._schemasSupplier = null;
    }

    @JsonIgnore
    public void setSchemas(UnsafeSupplier<String[], Exception> schemasUnsafeSupplier) {
        this._schemasSupplier = () -> {
            try {
                return (String[])schemasUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The User's time zone, in IANA Time Zone database format, also known as the \"Olson\" time zone database format (e.g., \"America/Los_Angeles\").")
    public String getTimezone() {
        if (this._timezoneSupplier != null) {
            this.timezone = this._timezoneSupplier.get();
            this._timezoneSupplier = null;
        }
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
        this._timezoneSupplier = null;
    }

    @JsonIgnore
    public void setTimezone(UnsafeSupplier<String, Exception> timezoneUnsafeSupplier) {
        this._timezoneSupplier = () -> {
            try {
                return (String)timezoneUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The user's title, such as \"Vice President\".")
    public String getTitle() {
        if (this._titleSupplier != null) {
            this.title = this._titleSupplier.get();
            this._titleSupplier = null;
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this._titleSupplier = null;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<String, Exception> titleUnsafeSupplier) {
        this._titleSupplier = () -> {
            try {
                return (String)titleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The components of the Liferay's User Schema Extension.")
    @Valid
    public UserSchemaExtension getUrn_ietf_params_scim_schemas_extension_liferay_2_0_User() {
        if (this._urn_ietf_params_scim_schemas_extension_liferay_2_0_UserSupplier != null) {
            this.urn_ietf_params_scim_schemas_extension_liferay_2_0_User = this._urn_ietf_params_scim_schemas_extension_liferay_2_0_UserSupplier.get();
            this._urn_ietf_params_scim_schemas_extension_liferay_2_0_UserSupplier = null;
        }
        return this.urn_ietf_params_scim_schemas_extension_liferay_2_0_User;
    }

    public void setUrn_ietf_params_scim_schemas_extension_liferay_2_0_User(UserSchemaExtension urn_ietf_params_scim_schemas_extension_liferay_2_0_User) {
        this.urn_ietf_params_scim_schemas_extension_liferay_2_0_User = urn_ietf_params_scim_schemas_extension_liferay_2_0_User;
        this._urn_ietf_params_scim_schemas_extension_liferay_2_0_UserSupplier = null;
    }

    @JsonIgnore
    public void setUrn_ietf_params_scim_schemas_extension_liferay_2_0_User(UnsafeSupplier<UserSchemaExtension, Exception> urn_ietf_params_scim_schemas_extension_liferay_2_0_UserUnsafeSupplier) {
        this._urn_ietf_params_scim_schemas_extension_liferay_2_0_UserSupplier = () -> {
            try {
                return (UserSchemaExtension)urn_ietf_params_scim_schemas_extension_liferay_2_0_UserUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A service provider's unique identifier for the user, typically used by the user to directly authenticate to the service provider.")
    public String getUserName() {
        if (this._userNameSupplier != null) {
            this.userName = this._userNameSupplier.get();
            this._userNameSupplier = null;
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this._userNameSupplier = null;
    }

    @JsonIgnore
    public void setUserName(UnsafeSupplier<String, Exception> userNameUnsafeSupplier) {
        this._userNameSupplier = () -> {
            try {
                return (String)userNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Used to identify the relationship between the organization and the user.")
    public String getUserType() {
        if (this._userTypeSupplier != null) {
            this.userType = this._userTypeSupplier.get();
            this._userTypeSupplier = null;
        }
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
        this._userTypeSupplier = null;
    }

    @JsonIgnore
    public void setUserType(UnsafeSupplier<String, Exception> userTypeUnsafeSupplier) {
        this._userTypeSupplier = () -> {
            try {
                return (String)userTypeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of certificates associated with the resource (e.g., a User).")
    @Valid
    public MultiValuedAttribute[] getX509Certificates() {
        if (this._x509CertificatesSupplier != null) {
            this.x509Certificates = this._x509CertificatesSupplier.get();
            this._x509CertificatesSupplier = null;
        }
        return this.x509Certificates;
    }

    public void setX509Certificates(MultiValuedAttribute[] x509Certificates) {
        this.x509Certificates = x509Certificates;
        this._x509CertificatesSupplier = null;
    }

    @JsonIgnore
    public void setX509Certificates(UnsafeSupplier<MultiValuedAttribute[], Exception> x509CertificatesUnsafeSupplier) {
        this._x509CertificatesSupplier = () -> {
            try {
                return (MultiValuedAttribute[])x509CertificatesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return Objects.equals(this.toString(), user.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        MultiValuedAttribute[] x509Certificates;
        String userType;
        String userName;
        UserSchemaExtension urn_ietf_params_scim_schemas_extension_liferay_2_0_User;
        String title;
        String timezone;
        String[] schemas;
        MultiValuedAttribute[] roles;
        String profileUrl;
        String preferredLanguage;
        MultiValuedAttribute[] photos;
        MultiValuedAttribute[] phoneNumbers;
        String password;
        String nickName;
        Name name;
        Meta meta;
        String locale;
        MultiValuedAttribute[] ims;
        String id;
        MultiValuedAttribute[] groups;
        String externalId;
        MultiValuedAttribute[] entitlements;
        MultiValuedAttribute[] emails;
        String displayName;
        Object[] addresses;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Boolean active = this.getActive();
        if (active != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"active\": ");
            sb.append((Object)active);
        }
        if ((addresses = this.getAddresses()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"addresses\": ");
            sb.append("[");
            for (int i = 0; i < addresses.length; ++i) {
                sb.append("\"");
                sb.append(User._escape(addresses[i]));
                sb.append("\"");
                if (i + 1 >= addresses.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((displayName = this.getDisplayName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayName\": ");
            sb.append("\"");
            sb.append(User._escape(displayName));
            sb.append("\"");
        }
        if ((emails = this.getEmails()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"emails\": ");
            sb.append("[");
            for (int i = 0; i < emails.length; ++i) {
                sb.append(String.valueOf(emails[i]));
                if (i + 1 >= emails.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((entitlements = this.getEntitlements()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"entitlements\": ");
            sb.append("[");
            for (int i = 0; i < entitlements.length; ++i) {
                sb.append(String.valueOf(entitlements[i]));
                if (i + 1 >= entitlements.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((externalId = this.getExternalId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalId\": ");
            sb.append("\"");
            sb.append(User._escape(externalId));
            sb.append("\"");
        }
        if ((groups = this.getGroups()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"groups\": ");
            sb.append("[");
            for (int i = 0; i < groups.length; ++i) {
                sb.append(String.valueOf(groups[i]));
                if (i + 1 >= groups.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append("\"");
            sb.append(User._escape(id));
            sb.append("\"");
        }
        if ((ims = this.getIms()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"ims\": ");
            sb.append("[");
            for (int i = 0; i < ims.length; ++i) {
                sb.append(String.valueOf(ims[i]));
                if (i + 1 >= ims.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((locale = this.getLocale()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"locale\": ");
            sb.append("\"");
            sb.append(User._escape(locale));
            sb.append("\"");
        }
        if ((meta = this.getMeta()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"meta\": ");
            sb.append(String.valueOf(meta));
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append(String.valueOf(name));
        }
        if ((nickName = this.getNickName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"nickName\": ");
            sb.append("\"");
            sb.append(User._escape(nickName));
            sb.append("\"");
        }
        if ((password = this.getPassword()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"password\": ");
            sb.append("\"");
            sb.append(User._escape(password));
            sb.append("\"");
        }
        if ((phoneNumbers = this.getPhoneNumbers()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"phoneNumbers\": ");
            sb.append("[");
            for (int i = 0; i < phoneNumbers.length; ++i) {
                sb.append(String.valueOf(phoneNumbers[i]));
                if (i + 1 >= phoneNumbers.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((photos = this.getPhotos()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"photos\": ");
            sb.append("[");
            for (int i = 0; i < photos.length; ++i) {
                sb.append(String.valueOf(photos[i]));
                if (i + 1 >= photos.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((preferredLanguage = this.getPreferredLanguage()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"preferredLanguage\": ");
            sb.append("\"");
            sb.append(User._escape(preferredLanguage));
            sb.append("\"");
        }
        if ((profileUrl = this.getProfileUrl()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"profileUrl\": ");
            sb.append("\"");
            sb.append(User._escape(profileUrl));
            sb.append("\"");
        }
        if ((roles = this.getRoles()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"roles\": ");
            sb.append("[");
            for (int i = 0; i < roles.length; ++i) {
                sb.append(String.valueOf(roles[i]));
                if (i + 1 >= roles.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((schemas = this.getSchemas()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"schemas\": ");
            sb.append("[");
            for (int i = 0; i < schemas.length; ++i) {
                sb.append("\"");
                sb.append(User._escape(schemas[i]));
                sb.append("\"");
                if (i + 1 >= schemas.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((timezone = this.getTimezone()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"timezone\": ");
            sb.append("\"");
            sb.append(User._escape(timezone));
            sb.append("\"");
        }
        if ((title = this.getTitle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(User._escape(title));
            sb.append("\"");
        }
        if ((urn_ietf_params_scim_schemas_extension_liferay_2_0_User = this.getUrn_ietf_params_scim_schemas_extension_liferay_2_0_User()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"urn:ietf:params:scim:schemas:extension:liferay:2.0:User\": ");
            sb.append(String.valueOf(urn_ietf_params_scim_schemas_extension_liferay_2_0_User));
        }
        if ((userName = this.getUserName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userName\": ");
            sb.append("\"");
            sb.append(User._escape(userName));
            sb.append("\"");
        }
        if ((userType = this.getUserType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userType\": ");
            sb.append("\"");
            sb.append(User._escape(userType));
            sb.append("\"");
        }
        if ((x509Certificates = this.getX509Certificates()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"x509Certificates\": ");
            sb.append("[");
            for (int i = 0; i < x509Certificates.length; ++i) {
                sb.append(String.valueOf(x509Certificates[i]));
                if (i + 1 >= x509Certificates.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(User._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (User._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(User._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(User._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(User._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

