/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="A complex attribute containing resource metadata.", value="Meta")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Meta")
public class Meta
implements Serializable {
    @GraphQLField(description="The \"DateTime\" that the resource was added to the service provider.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The \"DateTime\" that the resource was added to the service provider.") Date created;
    @JsonIgnore
    private Supplier<Date> _createdSupplier;
    @GraphQLField(description="The most recent DateTime that the details of this resource were updated at the service provider.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The most recent DateTime that the details of this resource were updated at the service provider.") Date lastModified;
    @JsonIgnore
    private Supplier<Date> _lastModifiedSupplier;
    @GraphQLField(description="The URI of the resource being returned.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The URI of the resource being returned.") String location;
    @JsonIgnore
    private Supplier<String> _locationSupplier;
    @GraphQLField(description="The name of the resource type of the resource.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The name of the resource type of the resource.") String resourceType;
    @JsonIgnore
    private Supplier<String> _resourceTypeSupplier;
    @GraphQLField(description="The version of the resource being returned.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The version of the resource being returned.") String version;
    @JsonIgnore
    private Supplier<String> _versionSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.scim.rest.dto.v1_0.Meta", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Meta toDTO(String json) {
        return (Meta)ObjectMapperUtil.readValue(Meta.class, (String)json);
    }

    public static Meta unsafeToDTO(String json) {
        return (Meta)ObjectMapperUtil.unsafeReadValue(Meta.class, (String)json);
    }

    @Schema(description="The \"DateTime\" that the resource was added to the service provider.")
    public Date getCreated() {
        if (this._createdSupplier != null) {
            this.created = this._createdSupplier.get();
            this._createdSupplier = null;
        }
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
        this._createdSupplier = null;
    }

    @JsonIgnore
    public void setCreated(UnsafeSupplier<Date, Exception> createdUnsafeSupplier) {
        this._createdSupplier = () -> {
            try {
                return (Date)createdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The most recent DateTime that the details of this resource were updated at the service provider.")
    public Date getLastModified() {
        if (this._lastModifiedSupplier != null) {
            this.lastModified = this._lastModifiedSupplier.get();
            this._lastModifiedSupplier = null;
        }
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        this._lastModifiedSupplier = null;
    }

    @JsonIgnore
    public void setLastModified(UnsafeSupplier<Date, Exception> lastModifiedUnsafeSupplier) {
        this._lastModifiedSupplier = () -> {
            try {
                return (Date)lastModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The URI of the resource being returned.")
    public String getLocation() {
        if (this._locationSupplier != null) {
            this.location = this._locationSupplier.get();
            this._locationSupplier = null;
        }
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this._locationSupplier = null;
    }

    @JsonIgnore
    public void setLocation(UnsafeSupplier<String, Exception> locationUnsafeSupplier) {
        this._locationSupplier = () -> {
            try {
                return (String)locationUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The name of the resource type of the resource.")
    public String getResourceType() {
        if (this._resourceTypeSupplier != null) {
            this.resourceType = this._resourceTypeSupplier.get();
            this._resourceTypeSupplier = null;
        }
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
        this._resourceTypeSupplier = null;
    }

    @JsonIgnore
    public void setResourceType(UnsafeSupplier<String, Exception> resourceTypeUnsafeSupplier) {
        this._resourceTypeSupplier = () -> {
            try {
                return (String)resourceTypeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The version of the resource being returned.")
    public String getVersion() {
        if (this._versionSupplier != null) {
            this.version = this._versionSupplier.get();
            this._versionSupplier = null;
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this._versionSupplier = null;
    }

    @JsonIgnore
    public void setVersion(UnsafeSupplier<String, Exception> versionUnsafeSupplier) {
        this._versionSupplier = () -> {
            try {
                return (String)versionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Meta)) {
            return false;
        }
        Meta meta = (Meta)object;
        return Objects.equals(this.toString(), meta.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String version;
        String resourceType;
        String location;
        Date lastModified;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Date created = this.getCreated();
        if (created != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"created\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(created));
            sb.append("\"");
        }
        if ((lastModified = this.getLastModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"lastModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(lastModified));
            sb.append("\"");
        }
        if ((location = this.getLocation()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"location\": ");
            sb.append("\"");
            sb.append(Meta._escape(location));
            sb.append("\"");
        }
        if ((resourceType = this.getResourceType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"resourceType\": ");
            sb.append("\"");
            sb.append(Meta._escape(resourceType));
            sb.append("\"");
        }
        if ((version = this.getVersion()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"version\": ");
            sb.append("\"");
            sb.append(Meta._escape(version));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Meta._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Meta._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Meta._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Meta._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Meta._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

