/*
 * BridJ - Dynamic and blazing-fast native interop for Java.
 * http://bridj.googlecode.com/
 *
 * Copyright (c) 2010-2013, Olivier Chafik (http://ochafik.com/)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Olivier Chafik nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY OLIVIER CHAFIK AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.bridj.cpp.com;

import java.util.Collections;
import java.util.Iterator;
import org.bridj.BridJ;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.TypedPointer;
import org.bridj.ValuedEnum;
import org.bridj.ann.CLong;
import org.bridj.ann.Field;
import org.bridj.ann.Library;
import org.bridj.ann.Runtime;
import org.bridj.cpp.CPPObject;
import org.bridj.cpp.CPPRuntime;

/**
 * Wrapper for library <b>oleaut32</b><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("oleaut32")
@Runtime(CPPRuntime.class)
public class OLEAutomationLibrary {

    static {
        BridJ.register();
    }

    /// <i>native declaration : line 33</i>
    public static class ITypeLib extends CPPObject {
//		public ITypeLib() {
//			super();
//		}
//		public ITypeLib(Pointer pointer) {
//			super(pointer);
//		}
    };
    /// <i>native declaration : line 34</i>

    public static class ICreateTypeLib extends CPPObject {
//		public ICreateTypeLib() {
//			super();
//		}
//		public ICreateTypeLib(Pointer pointer) {
//			super(pointer);
//		}
    };
    /// <i>native declaration : line 35</i>

    public static class ICreateTypeLib2 extends CPPObject {
//		public ICreateTypeLib2() {
//			super();
//		}
//		public ICreateTypeLib2(Pointer pointer) {
//			super(pointer);
//		}
    };
    /// <i>native declaration : line 36</i>

    public static class ICreateErrorInfo extends CPPObject {
//		public ICreateErrorInfo() {
//			super();
//		}
//		public ICreateErrorInfo(Pointer pointer) {
//			super(pointer);
//		}
    };
    /// <i>native declaration : line 37</i>

    public static class IErrorInfo extends CPPObject {
//		public IErrorInfo() {
//			super();
//		}
//		public IErrorInfo(Pointer pointer) {
//			super(pointer);
//		}
    };

    public enum SYSKIND implements IntValuedEnum<SYSKIND> {

        SYS_WIN16(0),
        SYS_WIN32(1),
        SYS_MAC(2);

        SYSKIND(long value) {
            this.value = value;
        }
        public final long value;

        public long value() {
            return this.value;
        }

        public Iterator<SYSKIND> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static ValuedEnum<SYSKIND> fromValue(long value) {
            return FlagSet.fromValue(value, values());
        }
    };

    public enum CALLCONV implements IntValuedEnum<CALLCONV> {

        CC_FASTCALL(0),
        CC_CDECL(1),
        CC_MSCPASCAL(2),
        CC_PASCAL(CC_MSCPASCAL.value()),
        CC_MACPASCAL(CC_MSCPASCAL.value() + 1),
        CC_STDCALL(CC_MSCPASCAL.value() + 2),
        CC_FPFASTCALL(CC_MSCPASCAL.value() + 3),
        CC_SYSCALL(CC_MSCPASCAL.value() + 4),
        CC_MPWCDECL(CC_MSCPASCAL.value() + 5),
        CC_MPWPASCAL(CC_MSCPASCAL.value() + 6),
        CC_MAX(CC_MSCPASCAL.value() + 7);

        CALLCONV(long value) {
            this.value = value;
        }
        public final long value;

        public long value() {
            return this.value;
        }

        public Iterator<CALLCONV> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static ValuedEnum<CALLCONV> fromValue(long value) {
            return FlagSet.fromValue(value, values());
        }
    };

    public enum REGKIND implements IntValuedEnum<REGKIND> {

        REGKIND_DEFAULT(0),
        REGKIND_REGISTER(1),
        REGKIND_NONE(2);

        REGKIND(long value) {
            this.value = value;
        }
        public final long value;

        public long value() {
            return this.value;
        }

        public Iterator<REGKIND> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static ValuedEnum<REGKIND> fromValue(long value) {
            return FlagSet.fromValue(value, values());
        }
    };
    public static final int NUMPRS_TRAILING_WHITE = 2;
    public static final int VAR_TIMEVALUEONLY = 1;
    public static final int VARIANT_USE_NLS = 128;
    public static final int VTDATEGRE_MIN = -657434;
    public static final int ACTIVEOBJECT_WEAK = 1;
    public static final int NUMPRS_EXPONENT = 2048;
    public static final int NUMPRS_USE_ALL = 4096;
    public static final int NUMPRS_THOUSANDS = 512;
    public static final int STDOLE_MINORVERNUM = 0;
    public static final int VARIANT_LOCALBOOL = 16;
    public static final int VARIANT_NOVALUEPROP = 1;
    public static final int NUMPRS_PARENS = 128;
    public static final int VARCMP_GT = 2;
    public static final int VARCMP_LT = 0;
    public static final int NUMPRS_STD = 8191;
    public static final int VAR_CALENDAR_GREGORIAN = 256;
    public static final int NUMPRS_LEADING_PLUS = 4;
    public static final int LOAD_TLB_AS_64BIT = 64;
    public static final int LOCALE_USE_NLS = 268435456;
    public static final int VTDATEGRE_MAX = 2958465;
    public static final int NUMPRS_DECIMAL = 256;
    public static final int STDOLE_MAJORVERNUM = 1;
    public static final int NUMPRS_INEXACT = 131072;
    public static final int VARIANT_CALENDAR_THAI = 32;
    public static final int VARCMP_EQ = 1;
    public static final int ACTIVEOBJECT_STRONG = 0;
    public static final int NUMPRS_TRAILING_PLUS = 8;
    public static final int STDOLE2_MINORVERNUM = 0;
    public static final int VARIANT_NOUSEROVERRIDE = 4;
    public static final int NUMPRS_CURRENCY = 1024;
    public static final int VAR_CALENDAR_THAI = 128;
    public static final int STDOLE2_LCID = 0;
    public static final int VAR_FOURDIGITYEARS = 64;
    public static final int DISPATCH_PROPERTYPUT = 4;
    public static final int VARIANT_CALENDAR_GREGORIAN = 64;
    public static final int NUMPRS_HEX_OCT = 64;
    public static final int NUMPRS_LEADING_WHITE = 1;
    public static final int DISPATCH_PROPERTYPUTREF = 8;
    public static final int ID_DEFAULTINST = -2;
    public static final int VAR_LOCALBOOL = 16;
    public static final int STDOLE_LCID = 0;
    public static final int NUMPRS_TRAILING_MINUS = 32;
    public static final int NUMPRS_LEADING_MINUS = 16;
    public static final int VARIANT_ALPHABOOL = 2;
    public static final int VAR_VALIDDATE = 4;
    public static final int VARIANT_CALENDAR_HIJRI = 8;
    public static final int VAR_DATEVALUEONLY = 2;
    public static final int STDOLE2_MAJORVERNUM = 2;
    public static final int LOAD_TLB_AS_32BIT = 32;
    public static final int NUMPRS_NEG = 65536;
    public static final int VAR_CALENDAR_HIJRI = 8;
    public static final int DISPATCH_METHOD = 1;
    public static final int VARCMP_NULL = 3;
    public static final int DISPATCH_PROPERTYGET = 2;
    public static final int VAR_FORMAT_NOSUBSTITUTE = 32;
    public static final int MASK_TO_RESET_TLB_BITS = ~(LOAD_TLB_AS_32BIT | LOAD_TLB_AS_64BIT);

    public static class DATE extends StructObject {

        public DATE() {
            super();
        }
//		public DATE(Pointer pointer) {
//			super(pointer);
//		}
    };

    public static class DISPPARAMS extends StructObject {

        public DISPPARAMS() {
            super();
        }
//		public DISPPARAMS(Pointer pointer) {
//			super(pointer);
//		}
    };
    /// <i>native declaration : line 22</i>

    public static class EXCEPINFO extends StructObject {

        public EXCEPINFO() {
            super();
        }
//		public EXCEPINFO(Pointer pointer) {
//			super(pointer);
//		}
    };

    public static class CUSTDATAITEM extends StructObject {

        public CUSTDATAITEM() {
            super();
        }
//		public CUSTDATAITEM(Pointer pointer) {
//			super(pointer);
//		}
        /// C type : GUID

        @Field(0)
        public GUID guid() {
            return this.io.getNativeObjectField(this, 0);
        }
        /// C type : VARIANTARG

        @Field(1)
        public VARIANT varValue() {
            return this.io.getNativeObjectField(this, 1);
        }
    };

    public static class CUSTDATA extends StructObject {

        public CUSTDATA() {
            super();
        }
//		public CUSTDATA(Pointer pointer) {
//			super(pointer);
//		}

        @Field(0)
        public int cCustData() {
            return this.io.getIntField(this, 0);
        }

        @Field(0)
        public CUSTDATA cCustData(int cCustData) {
            this.io.setIntField(this, 0, cCustData);
            return this;
        }

        public final int cCustData_$eq(int cCustData) {
            cCustData(cCustData);
            return cCustData;
        }
        /// C type : LPCUSTDATAITEM

        @Field(1)
        public Pointer<CUSTDATAITEM> prgCustData() {
            return this.io.getPointerField(this, 1);
        }
        /// C type : LPCUSTDATAITEM

        @Field(1)
        public CUSTDATA prgCustData(Pointer<CUSTDATAITEM> prgCustData) {
            this.io.setPointerField(this, 1, prgCustData);
            return this;
        }
        /// C type : LPCUSTDATAITEM

        public final Pointer<CUSTDATAITEM> prgCustData_$eq(Pointer<CUSTDATAITEM> prgCustData) {
            prgCustData(prgCustData);
            return prgCustData;
        }
    }

    public static class SYSTEMTIME extends StructObject {

        public SYSTEMTIME() {
            super();
        }
//		public SYSTEMTIME(Pointer pointer) {
//			super(pointer);
//		}

        @Field(0)
        public short wYear() {
            return this.io.getShortField(this, 0);
        }

        @Field(0)
        public SYSTEMTIME wYear(short wYear) {
            this.io.setShortField(this, 0, wYear);
            return this;
        }

        public final short wYear_$eq(short wYear) {
            wYear(wYear);
            return wYear;
        }

        @Field(1)
        public short wMonth() {
            return this.io.getShortField(this, 1);
        }

        @Field(1)
        public SYSTEMTIME wMonth(short wMonth) {
            this.io.setShortField(this, 1, wMonth);
            return this;
        }

        public final short wMonth_$eq(short wMonth) {
            wMonth(wMonth);
            return wMonth;
        }

        @Field(2)
        public short wDayOfWeek() {
            return this.io.getShortField(this, 2);
        }

        @Field(2)
        public SYSTEMTIME wDayOfWeek(short wDayOfWeek) {
            this.io.setShortField(this, 2, wDayOfWeek);
            return this;
        }

        public final short wDayOfWeek_$eq(short wDayOfWeek) {
            wDayOfWeek(wDayOfWeek);
            return wDayOfWeek;
        }

        @Field(3)
        public short wDay() {
            return this.io.getShortField(this, 3);
        }

        @Field(3)
        public SYSTEMTIME wDay(short wDay) {
            this.io.setShortField(this, 3, wDay);
            return this;
        }

        public final short wDay_$eq(short wDay) {
            wDay(wDay);
            return wDay;
        }

        @Field(4)
        public short wHour() {
            return this.io.getShortField(this, 4);
        }

        @Field(4)
        public SYSTEMTIME wHour(short wHour) {
            this.io.setShortField(this, 4, wHour);
            return this;
        }

        public final short wHour_$eq(short wHour) {
            wHour(wHour);
            return wHour;
        }

        @Field(5)
        public short wMinute() {
            return this.io.getShortField(this, 5);
        }

        @Field(5)
        public SYSTEMTIME wMinute(short wMinute) {
            this.io.setShortField(this, 5, wMinute);
            return this;
        }

        public final short wMinute_$eq(short wMinute) {
            wMinute(wMinute);
            return wMinute;
        }

        @Field(6)
        public short wSecond() {
            return this.io.getShortField(this, 6);
        }

        @Field(6)
        public SYSTEMTIME wSecond(short wSecond) {
            this.io.setShortField(this, 6, wSecond);
            return this;
        }

        public final short wSecond_$eq(short wSecond) {
            wSecond(wSecond);
            return wSecond;
        }

        @Field(7)
        public short wMilliseconds() {
            return this.io.getShortField(this, 7);
        }

        @Field(7)
        public SYSTEMTIME wMilliseconds(short wMilliseconds) {
            this.io.setShortField(this, 7, wMilliseconds);
            return this;
        }

        public final short wMilliseconds_$eq(short wMilliseconds) {
            wMilliseconds(wMilliseconds);
            return wMilliseconds;
        }
    };

    public static class UDATE extends StructObject {

        public UDATE() {
            super();
        }
//		public UDATE(Pointer pointer) {
//			super(pointer);
//		}
        /// C type : SYSTEMTIME

        @Field(0)
        public SYSTEMTIME st() {
            return this.io.getNativeObjectField(this, 0);
        }
        /// C type : USHORT

        @Field(1)
        public short wDayOfYear() {
            return this.io.getShortField(this, 1);
        }
        /// C type : USHORT

        @Field(1)
        public UDATE wDayOfYear(short wDayOfYear) {
            this.io.setShortField(this, 1, wDayOfYear);
            return this;
        }
        /// C type : USHORT

        public final short wDayOfYear_$eq(short wDayOfYear) {
            wDayOfYear(wDayOfYear);
            return wDayOfYear;
        }
    };

    public static class NUMPARSE extends StructObject {

        public NUMPARSE() {
            super();
        }
//		public NUMPARSE(Pointer pointer) {
//			super(pointer);
//		}

        /**
         * Number of parsed digits<br>
         * C type : INT
         */
        @Field(0)
        public int cDig() {
            return this.io.getIntField(this, 0);
        }

        /**
         * Number of parsed digits<br>
         * C type : INT
         */
        @Field(0)
        public NUMPARSE cDig(int cDig) {
            this.io.setIntField(this, 0, cDig);
            return this;
        }
        /// C type : INT

        public final int cDig_$eq(int cDig) {
            cDig(cDig);
            return cDig;
        }

        /**
         * Acceptable state of the input string (NUMPRS_ flags)<br>
         * C type : ULONG
         */
        @Field(1)
        public int dwInFlags() {
            return this.io.getIntField(this, 1);
        }

        /**
         * Acceptable state of the input string (NUMPRS_ flags)<br>
         * C type : ULONG
         */
        @Field(1)
        public NUMPARSE dwInFlags(int dwInFlags) {
            this.io.setIntField(this, 1, dwInFlags);
            return this;
        }
        /// C type : ULONG

        public final int dwInFlags_$eq(int dwInFlags) {
            dwInFlags(dwInFlags);
            return dwInFlags;
        }

        /**
         * Parsed state of the output string (NUMPRS_ flags)<br>
         * C type : ULONG
         */
        @Field(2)
        public int dwOutFlags() {
            return this.io.getIntField(this, 2);
        }

        /**
         * Parsed state of the output string (NUMPRS_ flags)<br>
         * C type : ULONG
         */
        @Field(2)
        public NUMPARSE dwOutFlags(int dwOutFlags) {
            this.io.setIntField(this, 2, dwOutFlags);
            return this;
        }
        /// C type : ULONG

        public final int dwOutFlags_$eq(int dwOutFlags) {
            dwOutFlags(dwOutFlags);
            return dwOutFlags;
        }

        /**
         * Number of characters parsed from input string<br>
         * C type : INT
         */
        @Field(3)
        public int cchUsed() {
            return this.io.getIntField(this, 3);
        }

        /**
         * Number of characters parsed from input string<br>
         * C type : INT
         */
        @Field(3)
        public NUMPARSE cchUsed(int cchUsed) {
            this.io.setIntField(this, 3, cchUsed);
            return this;
        }
        /// C type : INT

        public final int cchUsed_$eq(int cchUsed) {
            cchUsed(cchUsed);
            return cchUsed;
        }

        /**
         * Base of the number (but apparently unused)<br>
         * C type : INT
         */
        @Field(4)
        public int nBaseShift() {
            return this.io.getIntField(this, 4);
        }

        /**
         * Base of the number (but apparently unused)<br>
         * C type : INT
         */
        @Field(4)
        public NUMPARSE nBaseShift(int nBaseShift) {
            this.io.setIntField(this, 4, nBaseShift);
            return this;
        }
        /// C type : INT

        public final int nBaseShift_$eq(int nBaseShift) {
            nBaseShift(nBaseShift);
            return nBaseShift;
        }

        /**
         * Scale of the number in powers of 10<br>
         * C type : INT
         */
        @Field(5)
        public int nPwr10() {
            return this.io.getIntField(this, 5);
        }

        /**
         * Scale of the number in powers of 10<br>
         * C type : INT
         */
        @Field(5)
        public NUMPARSE nPwr10(int nPwr10) {
            this.io.setIntField(this, 5, nPwr10);
            return this;
        }
        /// C type : INT

        public final int nPwr10_$eq(int nPwr10) {
            nPwr10(nPwr10);
            return nPwr10;
        }
    };

    public static class PARAMDATA extends StructObject {

        public PARAMDATA() {
            super();
        }
//		public PARAMDATA(Pointer pointer) {
//			super(pointer);
//		}

        /**
         * Name of Parameter<br>
         * C type : OLECHAR*
         */
        @Field(0)
        public Pointer<Character> szName() {
            return this.io.getPointerField(this, 0);
        }

        /**
         * Name of Parameter<br>
         * C type : OLECHAR*
         */
        @Field(0)
        public PARAMDATA szName(Pointer<Character> szName) {
            this.io.setPointerField(this, 0, szName);
            return this;
        }
        /// C type : OLECHAR*

        public final Pointer<Character> szName_$eq(Pointer<Character> szName) {
            szName(szName);
            return szName;
        }

        /**
         * Type of Parameter<br>
         * C type : VARTYPE
         */
        @Field(1)
        public short vt() {
            return this.io.getShortField(this, 1);
        }

        /**
         * Type of Parameter<br>
         * C type : VARTYPE
         */
        @Field(1)
        public PARAMDATA vt(short vt) {
            this.io.setShortField(this, 1, vt);
            return this;
        }
        /// C type : VARTYPE

        public final short vt_$eq(short vt) {
            vt(vt);
            return vt;
        }
    };

    public static class METHODDATA extends StructObject {

        public METHODDATA() {
            super();
        }
//		public METHODDATA(Pointer pointer) {
//			super(pointer);
//		}

        /**
         * Name of method<br>
         * C type : OLECHAR*
         */
        @Field(0)
        public Pointer<Character> szName() {
            return this.io.getPointerField(this, 0);
        }

        /**
         * Name of method<br>
         * C type : OLECHAR*
         */
        @Field(0)
        public METHODDATA szName(Pointer<Character> szName) {
            this.io.setPointerField(this, 0, szName);
            return this;
        }
        /// C type : OLECHAR*

        public final Pointer<Character> szName_$eq(Pointer<Character> szName) {
            szName(szName);
            return szName;
        }

        /**
         * Parameters of the method<br>
         * C type : PARAMDATA*
         */
        @Field(1)
        public Pointer<PARAMDATA> ppdata() {
            return this.io.getPointerField(this, 1);
        }

        /**
         * Parameters of the method<br>
         * C type : PARAMDATA*
         */
        @Field(1)
        public METHODDATA ppdata(Pointer<PARAMDATA> ppdata) {
            this.io.setPointerField(this, 1, ppdata);
            return this;
        }
        /// C type : PARAMDATA*

        public final Pointer<PARAMDATA> ppdata_$eq(Pointer<PARAMDATA> ppdata) {
            ppdata(ppdata);
            return ppdata;
        }

        /**
         * Id of the method<br>
         * C type : DISPID
         */
        @CLong
        @Field(2)
        public long dispid() {
            return this.io.getCLongField(this, 2);
        }

        /**
         * Id of the method<br>
         * C type : DISPID
         */
        @CLong
        @Field(2)
        public METHODDATA dispid(long dispid) {
            this.io.setCLongField(this, 2, dispid);
            return this;
        }
        /// C type : DISPID

        public final long dispid_$eq(long dispid) {
            dispid(dispid);
            return dispid;
        }

        /**
         * Vtable index of the method<br>
         * C type : UINT
         */
        @Field(3)
        public int iMeth() {
            return this.io.getIntField(this, 3);
        }

        /**
         * Vtable index of the method<br>
         * C type : UINT
         */
        @Field(3)
        public METHODDATA iMeth(int iMeth) {
            this.io.setIntField(this, 3, iMeth);
            return this;
        }
        /// C type : UINT

        public final int iMeth_$eq(int iMeth) {
            iMeth(iMeth);
            return iMeth;
        }

        /**
         * Calling convention of the method<br>
         * C type : CALLCONV
         */
        @Field(4)
        public ValuedEnum<CALLCONV> cc() {
            return this.io.getEnumField(this, 4);
        }

        /**
         * Calling convention of the method<br>
         * C type : CALLCONV
         */
        @Field(4)
        public METHODDATA cc(ValuedEnum<CALLCONV> cc) {
            this.io.setEnumField(this, 4, cc);
            return this;
        }
        /// C type : CALLCONV

        public final ValuedEnum<CALLCONV> cc_$eq(ValuedEnum<CALLCONV> cc) {
            cc(cc);
            return cc;
        }

        /**
         * Number of parameters in the method<br>
         * C type : UINT
         */
        @Field(5)
        public int cArgs() {
            return this.io.getIntField(this, 5);
        }

        /**
         * Number of parameters in the method<br>
         * C type : UINT
         */
        @Field(5)
        public METHODDATA cArgs(int cArgs) {
            this.io.setIntField(this, 5, cArgs);
            return this;
        }
        /// C type : UINT

        public final int cArgs_$eq(int cArgs) {
            cArgs(cArgs);
            return cArgs;
        }
        /// Type of the method (DISPATCH_ flags)

        @Field(6)
        public short wFlags() {
            return this.io.getShortField(this, 6);
        }
        /// Type of the method (DISPATCH_ flags)

        @Field(6)
        public METHODDATA wFlags(short wFlags) {
            this.io.setShortField(this, 6, wFlags);
            return this;
        }

        public final short wFlags_$eq(short wFlags) {
            wFlags(wFlags);
            return wFlags;
        }

        /**
         * Type of the return value<br>
         * C type : VARTYPE
         */
        @Field(7)
        public short vtReturn() {
            return this.io.getShortField(this, 7);
        }

        /**
         * Type of the return value<br>
         * C type : VARTYPE
         */
        @Field(7)
        public METHODDATA vtReturn(short vtReturn) {
            this.io.setShortField(this, 7, vtReturn);
            return this;
        }
        /// C type : VARTYPE

        public final short vtReturn_$eq(short vtReturn) {
            vtReturn(vtReturn);
            return vtReturn;
        }
    };

    public static class INTERFACEDATA extends StructObject {

        public INTERFACEDATA() {
            super();
        }
//		public INTERFACEDATA(Pointer pointer) {
//			super(pointer);
//		}

        /**
         * Methods of the object<br>
         * C type : METHODDATA*
         */
        @Field(0)
        public Pointer<METHODDATA> pmethdata() {
            return this.io.getPointerField(this, 0);
        }

        /**
         * Methods of the object<br>
         * C type : METHODDATA*
         */
        @Field(0)
        public INTERFACEDATA pmethdata(Pointer<METHODDATA> pmethdata) {
            this.io.setPointerField(this, 0, pmethdata);
            return this;
        }
        /// C type : METHODDATA*

        public final Pointer<METHODDATA> pmethdata_$eq(Pointer<METHODDATA> pmethdata) {
            pmethdata(pmethdata);
            return pmethdata;
        }

        /**
         * Number of methods in the object<br>
         * C type : UINT
         */
        @Field(1)
        public int cMembers() {
            return this.io.getIntField(this, 1);
        }

        /**
         * Number of methods in the object<br>
         * C type : UINT
         */
        @Field(1)
        public INTERFACEDATA cMembers(int cMembers) {
            this.io.setIntField(this, 1, cMembers);
            return this;
        }
        /// C type : UINT

        public final int cMembers_$eq(int cMembers) {
            cMembers(cMembers);
            return cMembers;
        }
    };

    public static native int OaBuildVersion();

    public static native Pointer<Byte> SysAllocString(Pointer<Character> OLECHARPtr1);

    public static native Pointer<Byte> SysAllocStringByteLen(int UINT1);

    public static native Pointer<Byte> SysAllocStringLen(Pointer<Character> OLECHARPtr1, int UINT1);

    public static native void SysFreeString(Pointer<Byte> BSTR1);

    public static native int SysReAllocString(Pointer<Pointer<Byte>> LPBSTR1, Pointer<Character> OLECHARPtr1);

    public static native int SysReAllocStringLen(Pointer<Pointer<Byte>> BSTRPtr1, Pointer<Character> OLECHARPtr1, int UINT1);

    public static native int SysStringByteLen(Pointer<Byte> BSTR1);

    public static native int SysStringLen(Pointer<Byte> BSTR1);

    public static native int SetErrorInfo(int ULONG1, Pointer<IErrorInfo> IErrorInfoPtr1);

    public static native int GetErrorInfo(int ULONG1, Pointer<Pointer<IErrorInfo>> IErrorInfoPtrPtr1);

    public static native int CreateErrorInfo(Pointer<Pointer<ICreateErrorInfo>> ICreateErrorInfoPtrPtr1);

    public static native Pointer<SAFEARRAY> SafeArrayCreate(short VARTYPE1, int UINT1, Pointer<SAFEARRAYBOUND> SAFEARRAYBOUNDPtr1);

    public static native Pointer<SAFEARRAY> SafeArrayCreateEx(short VARTYPE1, int UINT1, Pointer<SAFEARRAYBOUND> SAFEARRAYBOUNDPtr1);

    public static native Pointer<SAFEARRAY> SafeArrayCreateVector(short VARTYPE1, @CLong long LONG1, int ULONG1);

    public static native Pointer<SAFEARRAY> SafeArrayCreateVectorEx(short VARTYPE1, @CLong long LONG1, int ULONG1);

    public static native int SafeArrayAllocDescriptor(int UINT1, Pointer<Pointer<SAFEARRAY>> SAFEARRAYPtrPtr1);

    public static native int SafeArrayAllocDescriptorEx(short VARTYPE1, int UINT1, Pointer<Pointer<SAFEARRAY>> SAFEARRAYPtrPtr1);

    public static native int SafeArrayAllocData(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayDestroyDescriptor(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayPutElement(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<org.bridj.CLong> LONGPtr1, Pointer<?> voidPtr1);

    public static native int SafeArrayGetElement(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<org.bridj.CLong> LONGPtr1, Pointer<?> voidPtr1);

    public static native int SafeArrayLock(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayUnlock(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayGetUBound(Pointer<SAFEARRAY> SAFEARRAYPtr1, int UINT1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int SafeArrayGetLBound(Pointer<SAFEARRAY> SAFEARRAYPtr1, int UINT1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int SafeArrayGetDim(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayGetElemsize(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayGetVartype(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<Short> VARTYPEPtr1);

    public static native int SafeArrayAccessData(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<Pointer<?>> voidPtrPtr1);

    public static native int SafeArrayUnaccessData(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayPtrOfIndex(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<org.bridj.CLong> LONGPtr1, Pointer<Pointer<?>> voidPtrPtr1);

    public static native int SafeArrayCopyData(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<SAFEARRAY> SAFEARRAYPtr2);

    public static native int SafeArrayDestroyData(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayDestroy(Pointer<SAFEARRAY> SAFEARRAYPtr1);

    public static native int SafeArrayCopy(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<Pointer<SAFEARRAY>> SAFEARRAYPtrPtr1);

    public static native int SafeArrayRedim(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<SAFEARRAYBOUND> SAFEARRAYBOUNDPtr1);

    public static native int SafeArraySetRecordInfo(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<IRecordInfo> IRecordInfoPtr1);

    public static native int SafeArrayGetRecordInfo(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<Pointer<IRecordInfo>> IRecordInfoPtrPtr1);

    public static native int SafeArraySetIID(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<GUID> REFGUID1);

    public static native int SafeArrayGetIID(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<GUID> GUIDPtr1);

    public static native int VectorFromBstr(Pointer<Byte> BSTR1, Pointer<Pointer<SAFEARRAY>> SAFEARRAYPtrPtr1);

    public static native int BstrFromVector(Pointer<SAFEARRAY> SAFEARRAYPtr1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int RegisterActiveObject(Pointer<IUnknown> LPUNKNOWN1, int DWORD1);

    public static native int RevokeActiveObject(int DWORD1);

    public static native int GetActiveObject(Pointer<Pointer<IUnknown>> LPUNKNOWNPtr1);

    public static native int GetRecordInfoFromTypeInfo(Pointer<ITypeInfo> ITypeInfoPtr1, Pointer<Pointer<IRecordInfo>> IRecordInfoPtrPtr1);

    public static native int GetRecordInfoFromGuids(Pointer<GUID> REFGUID1, int ULONG1, int ULONG2, int LCID1, Pointer<GUID> REFGUID2, Pointer<Pointer<IRecordInfo>> IRecordInfoPtrPtr1);

    public static native void VariantInit(Pointer<VARIANT> VARIANTPtr1);

    public static native int VariantClear(Pointer<VARIANT> VARIANTPtr1);

    public static native int VariantCopy(Pointer<VARIANT> VARIANTPtr1, Pointer<VARIANT> VARIANTPtr2);

    public static native int VariantCopyInd(Pointer<VARIANT> VARIANTPtr1, Pointer<VARIANT> VARIANTPtr2);

    public static native int VariantChangeType(Pointer<VARIANT> VARIANTPtr1, Pointer<VARIANT> VARIANTPtr2, short USHORT1, short VARTYPE1);

    public static native int VariantChangeTypeEx(Pointer<VARIANT> VARIANTPtr1, Pointer<VARIANT> VARIANTPtr2, int LCID1, short USHORT1, short VARTYPE1);

    public static native int VarUI1FromI2(short SHORT1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromI4(@CLong long LONG1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromI8(long LONG641, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromR4(float FLOAT1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromR8(double DOUBLE1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromDate(DATE DATE1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromBool(short VARIANT_BOOL1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromI1(byte char1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromUI2(short USHORT1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromUI4(int ULONG1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromUI8(long ULONG641, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromCy(CY CY1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Byte> BYTEPtr1);

    public static native int VarUI1FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Byte> BYTEPtr1);

    public static native int VarI2FromUI1(byte BYTE1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromI4(@CLong long LONG1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromI8(long LONG641, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromR4(float FLOAT1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromR8(double DOUBLE1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromDate(DATE DATE1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromBool(short VARIANT_BOOL1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromI1(byte char1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromUI2(short USHORT1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromUI4(int ULONG1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromUI8(long ULONG641, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromCy(CY CY1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Short> SHORTPtr1);

    public static native int VarI2FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Short> SHORTPtr1);

    public static native int VarI4FromUI1(byte BYTE1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromI2(short SHORT1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromI8(long LONG641, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromR4(float FLOAT1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromR8(double DOUBLE1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromDate(DATE DATE1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromBool(short VARIANT_BOOL1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromI1(byte char1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromUI2(short USHORT1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromUI4(int ULONG1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromUI8(long ULONG641, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromCy(CY CY1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI4FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<org.bridj.CLong> LONGPtr1);

    public static native int VarI8FromUI1(byte BYTE1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromI2(short SHORT1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromI4(@CLong long LONG1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromR4(float FLOAT1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromR8(double DOUBLE1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromDate(DATE DATE1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromBool(short VARIANT_BOOL1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromI1(byte char1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromUI2(short USHORT1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromUI4(int ULONG1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromUI8(long ULONG641, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromDec(Pointer<DECIMAL> pdecIn, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromInt(int intIn, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromCy(CY CY1, Pointer<Long> LONG64Ptr1);

    public static native int VarI8FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Long> LONG64Ptr1);

    public static native int VarR4FromUI1(byte BYTE1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromI2(short SHORT1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromI4(@CLong long LONG1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromI8(long LONG641, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromR8(double DOUBLE1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromDate(DATE DATE1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromBool(short VARIANT_BOOL1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromI1(byte char1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromUI2(short USHORT1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromUI4(int ULONG1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromUI8(long ULONG641, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromCy(CY CY1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Float> FLOATPtr1);

    public static native int VarR4FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Float> FLOATPtr1);

    public static native int VarR8FromUI1(byte BYTE1, Pointer<Double> doublePtr1);

    public static native int VarR8FromI2(short SHORT1, Pointer<Double> doublePtr1);

    public static native int VarR8FromI4(@CLong long LONG1, Pointer<Double> doublePtr1);

    public static native int VarR8FromI8(long LONG641, Pointer<Double> doublePtr1);

    public static native int VarR8FromR4(float FLOAT1, Pointer<Double> doublePtr1);

    public static native int VarR8FromDate(DATE DATE1, Pointer<Double> doublePtr1);

    public static native int VarR8FromBool(short VARIANT_BOOL1, Pointer<Double> doublePtr1);

    public static native int VarR8FromI1(byte char1, Pointer<Double> doublePtr1);

    public static native int VarR8FromUI2(short USHORT1, Pointer<Double> doublePtr1);

    public static native int VarR8FromUI4(int ULONG1, Pointer<Double> doublePtr1);

    public static native int VarR8FromUI8(long ULONG641, Pointer<Double> doublePtr1);

    public static native int VarR8FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Double> doublePtr1);

    public static native int VarR8FromCy(CY CY1, Pointer<Double> doublePtr1);

    public static native int VarR8FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Double> doublePtr1);

    public static native int VarR8FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Double> doublePtr1);

    public static native int VarDateFromUI1(byte BYTE1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromI2(short SHORT1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromI4(@CLong long LONG1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromI8(long LONG641, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromR4(float FLOAT1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromR8(double DOUBLE1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromI1(byte char1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromUI2(short USHORT1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromUI4(int ULONG1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromUI8(long ULONG641, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromBool(short VARIANT_BOOL1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromCy(CY CY1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<DATE> DATEPtr1);

    public static native int VarCyFromUI1(byte BYTE1, Pointer<CY> CYPtr1);

    public static native int VarCyFromI2(short sIn, Pointer<CY> CYPtr1);

    public static native int VarCyFromI4(@CLong long LONG1, Pointer<CY> CYPtr1);

    public static native int VarCyFromI8(long LONG641, Pointer<CY> CYPtr1);

    public static native int VarCyFromR4(float FLOAT1, Pointer<CY> CYPtr1);

    public static native int VarCyFromR8(double DOUBLE1, Pointer<CY> CYPtr1);

    public static native int VarCyFromDate(DATE DATE1, Pointer<CY> CYPtr1);

    public static native int VarCyFromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<CY> CYPtr1);

    public static native int VarCyFromBool(short VARIANT_BOOL1, Pointer<CY> CYPtr1);

    public static native int VarCyFromI1(byte char1, Pointer<CY> CYPtr1);

    public static native int VarCyFromUI2(short USHORT1, Pointer<CY> CYPtr1);

    public static native int VarCyFromUI4(int ULONG1, Pointer<CY> CYPtr1);

    public static native int VarCyFromUI8(long ULONG641, Pointer<CY> CYPtr1);

    public static native int VarCyFromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<CY> CYPtr1);

    public static native int VarCyFromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<CY> CYPtr1);

    public static native int VarBstrFromUI1(byte BYTE1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromI2(short SHORT1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromI4(@CLong long LONG1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromI8(long LONG641, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromR4(float FLOAT1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromR8(double DOUBLE1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromDate(DATE DATE1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromBool(short VARIANT_BOOL1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromI1(byte char1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromUI2(short USHORT1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromUI8(long ULONG641, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromUI4(int ULONG1, int LCID1, int ULONG2, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromCy(CY CY1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromDec(Pointer<DECIMAL> DECIMALPtr1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBstrFromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarBoolFromUI1(byte BYTE1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromI2(short SHORT1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromI4(@CLong long LONG1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromI8(long LONG641, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromR4(float FLOAT1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromR8(double DOUBLE1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromDate(DATE DATE1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromI1(byte char1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromUI2(short USHORT1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromUI4(int ULONG1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromUI8(long ULONG641, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromCy(CY CY1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarBoolFromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Short> VARIANT_BOOLPtr1);

    public static native int VarI1FromUI1(byte BYTE1, Pointer<Byte> charPtr1);

    public static native int VarI1FromI2(short SHORT1, Pointer<Byte> charPtr1);

    public static native int VarI1FromI4(@CLong long LONG1, Pointer<Byte> charPtr1);

    public static native int VarI1FromI8(long LONG641, Pointer<Byte> charPtr1);

    public static native int VarI1FromR4(float FLOAT1, Pointer<Byte> charPtr1);

    public static native int VarI1FromR8(double DOUBLE1, Pointer<Byte> charPtr1);

    public static native int VarI1FromDate(DATE DATE1, Pointer<Byte> charPtr1);

    public static native int VarI1FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Byte> charPtr1);

    public static native int VarI1FromBool(short VARIANT_BOOL1, Pointer<Byte> charPtr1);

    public static native int VarI1FromUI2(short USHORT1, Pointer<Byte> charPtr1);

    public static native int VarI1FromUI4(int ULONG1, Pointer<Byte> charPtr1);

    public static native int VarI1FromUI8(long ULONG641, Pointer<Byte> charPtr1);

    public static native int VarI1FromCy(CY CY1, Pointer<Byte> charPtr1);

    public static native int VarI1FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Byte> charPtr1);

    public static native int VarI1FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Byte> charPtr1);

    public static native int VarUI2FromUI1(byte BYTE1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromI2(short SHORT1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromI4(@CLong long LONG1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromI8(long LONG641, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromR4(float FLOAT1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromR8(double DOUBLE1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromDate(DATE DATE1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromBool(short VARIANT_BOOL1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromI1(byte char1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromUI4(int ULONG1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromUI8(long ULONG641, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromCy(CY CY1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Short> USHORTPtr1);

    public static native int VarUI2FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Short> USHORTPtr1);

    public static native int VarUI4FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromUI1(byte BYTE1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromI2(short SHORT1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromI4(@CLong long LONG1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromI8(long LONG641, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromR4(float FLOAT1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromR8(double DOUBLE1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromDate(DATE DATE1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromBool(short VARIANT_BOOL1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromI1(byte char1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromUI2(short USHORT1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromUI8(long ULONG641, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromCy(CY CY1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI4FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Integer> ULONGPtr1);

    public static native int VarUI8FromUI1(byte BYTE1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromI2(short SHORT1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromI4(@CLong long LONG1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromI8(long LONG641, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromR4(float FLOAT1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromR8(double DOUBLE1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromDate(DATE DATE1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromBool(short VARIANT_BOOL1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromI1(byte char1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromUI2(short USHORT1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromUI4(int ULONG1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromDec(Pointer<DECIMAL> DECIMALPtr1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromInt(int INT1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromCy(CY CY1, Pointer<Long> ULONG64Ptr1);

    public static native int VarUI8FromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<Long> ULONG64Ptr1);

    public static native int VarDecFromUI1(byte BYTE1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromI2(short SHORT1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromI4(@CLong long LONG1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromI8(long LONG641, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromR4(float FLOAT1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromR8(double DOUBLE1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromDate(DATE DATE1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromBool(short VARIANT_BOOL1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromI1(byte char1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromUI2(short USHORT1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromUI4(int ULONG1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromUI8(long ULONG641, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromCy(CY CY1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarDecFromDisp(Pointer<IDispatch> IDispatchPtr1, int LCID1, Pointer<DECIMAL> DECIMALPtr1);

    public static native int VarR4CmpR8(float float1, double double1);

    public static native int VarR8Pow(double double1, double double2, Pointer<Double> doublePtr1);

    public static native int VarR8Round(double double1, int int1, Pointer<Double> doublePtr1);

    public static native int VarDecAbs(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2);

    public static native int VarDecAdd(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2, Pointer<DECIMAL> DECIMALPtr3);

    public static native int VarDecCmp(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2);

    public static native int VarDecCmpR8(Pointer<DECIMAL> DECIMALPtr1, double DOUBLE1);

    public static native int VarDecDiv(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2, Pointer<DECIMAL> DECIMALPtr3);

    public static native int VarDecFix(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2);

    public static native int VarDecInt(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2);

    public static native int VarDecMul(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2, Pointer<DECIMAL> DECIMALPtr3);

    public static native int VarDecNeg(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2);

    public static native int VarDecRound(Pointer<DECIMAL> DECIMALPtr1, int int1, Pointer<DECIMAL> DECIMALPtr2);

    public static native int VarDecSub(Pointer<DECIMAL> DECIMALPtr1, Pointer<DECIMAL> DECIMALPtr2, Pointer<DECIMAL> DECIMALPtr3);

    public static native int VarCyAbs(CY CY1, Pointer<CY> CYPtr1);

    public static native int VarCyAdd(CY CY1, CY CY2, Pointer<CY> CYPtr1);

    public static native int VarCyCmp(CY CY1, CY CY2);

    public static native int VarCyCmpR8(CY CY1, double DOUBLE1);

    public static native int VarCyFix(CY CY1, Pointer<CY> CYPtr1);

    public static native int VarCyInt(CY CY1, Pointer<CY> CYPtr1);

    public static native int VarCyMul(CY CY1, CY CY2, Pointer<CY> CYPtr1);

    public static native int VarCyMulI4(CY CY1, @CLong long LONG1, Pointer<CY> CYPtr1);

    public static native int VarCyMulI8(CY CY1, long LONG641, Pointer<CY> CYPtr1);

    public static native int VarCyNeg(CY CY1, Pointer<CY> CYPtr1);

    public static native int VarCyRound(CY CY1, int INT1, Pointer<CY> CYPtr1);

    public static native int VarCySub(CY CY1, CY CY2, Pointer<CY> CYPtr1);

    public static native int VarAdd(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarAnd(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarCat(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarDiv(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarEqv(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarIdiv(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarImp(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarMod(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarMul(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarOr(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarPow(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarSub(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarXor(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, Pointer<VARIANT> LPVARIANT3);

    public static native int VarAbs(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2);

    public static native int VarFix(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2);

    public static native int VarInt(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2);

    public static native int VarNeg(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2);

    public static native int VarNot(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2);

    public static native int VarRound(Pointer<VARIANT> LPVARIANT1, int int1, Pointer<VARIANT> LPVARIANT2);

    public static native int VarCmp(Pointer<VARIANT> LPVARIANT1, Pointer<VARIANT> LPVARIANT2, int LCID1, int ULONG1);

    public static native int VarBstrCmp(Pointer<Byte> BSTR1, Pointer<Byte> BSTR2, int LCID1, int ULONG1);

    public static native int VarBstrCat(Pointer<Byte> BSTR1, Pointer<Byte> BSTR2, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarParseNumFromStr(Pointer<Character> OLECHARPtr1, int LCID1, int ULONG1, Pointer<NUMPARSE> NUMPARSEPtr1, Pointer<Byte> BYTEPtr1);

    public static native int VarNumFromParseNum(Pointer<NUMPARSE> NUMPARSEPtr1, Pointer<Byte> BYTEPtr1, int ULONG1, Pointer<VARIANT> VARIANTPtr1);

    public static native int DosDateTimeToVariantTime(short USHORT1, short USHORT2, Pointer<Double> doublePtr1);

    public static native int VariantTimeToDosDateTime(double double1, Pointer<Short> USHORTPtr1, Pointer<Short> USHORTPtr2);

    public static native int VariantTimeToSystemTime(double DOUBLE1, Pointer<SYSTEMTIME> LPSYSTEMTIME1);

    public static native int SystemTimeToVariantTime(Pointer<SYSTEMTIME> LPSYSTEMTIME1, Pointer<Double> doublePtr1);

    public static native int VarDateFromUdate(Pointer<UDATE> UDATEPtr1, int ULONG1, Pointer<DATE> DATEPtr1);

    public static native int VarDateFromUdateEx(Pointer<UDATE> UDATEPtr1, int LCID1, int ULONG1, Pointer<DATE> DATEPtr1);

    public static native int VarUdateFromDate(DATE DATE1, int ULONG1, Pointer<UDATE> UDATEPtr1);

    public static native int VarWeekdayName(int int1, int int2, int int3, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarMonthName(int int1, int int2, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int GetAltMonthNames(int LCID1, Pointer<Pointer<Pointer<Character>>> LPOLESTRPtrPtr1);

    public static native int VarFormat(Pointer<VARIANT> LPVARIANT1, Pointer<Character> LPOLESTR1, int int1, int int2, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarFormatCurrency(Pointer<VARIANT> LPVARIANT1, int int1, int int2, int int3, int int4, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarFormatDateTime(Pointer<VARIANT> LPVARIANT1, int int1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarFormatNumber(Pointer<VARIANT> LPVARIANT1, int int1, int int2, int int3, int int4, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarFormatPercent(Pointer<VARIANT> LPVARIANT1, int int1, int int2, int int3, int int4, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1);

    public static native int VarFormatFromTokens(Pointer<VARIANT> LPVARIANT1, Pointer<Character> LPOLESTR1, int ULONG1, Pointer<Pointer<Byte>> BSTRPtr1, int LCID1);

    public static native int VarTokenizeFormatString(Pointer<Character> LPOLESTR1, int int1, int int2, int int3, int LCID1, Pointer<Integer> intPtr1);

    public static native int DispGetParam(Pointer<DISPPARAMS> DISPPARAMSPtr1, int UINT1, short VARTYPE1, Pointer<VARIANT> VARIANTPtr1, Pointer<Integer> UINTPtr1);

    public static native int DispGetIDsOfNames(Pointer<ITypeInfo> ITypeInfoPtr1, Pointer<Pointer<Character>> OLECHARPtrPtr1, int UINT1, Pointer<org.bridj.CLong> DISPIDPtr1);

    public static native int DispInvoke(Pointer<?> voidPtr1, Pointer<ITypeInfo> ITypeInfoPtr1, @CLong long DISPID1, short WORD1, Pointer<DISPPARAMS> DISPPARAMSPtr1, Pointer<VARIANT> VARIANTPtr1, Pointer<EXCEPINFO> EXCEPINFOPtr1, Pointer<Integer> UINTPtr1);

    public static native int CreateDispTypeInfo(Pointer<INTERFACEDATA> INTERFACEDATAPtr1, int LCID1, Pointer<Pointer<ITypeInfo>> ITypeInfoPtrPtr1);

    public static native int CreateStdDispatch(Pointer<IUnknown> IUnknownPtr1, Pointer<?> voidPtr1, Pointer<ITypeInfo> ITypeInfoPtr1, Pointer<Pointer<IUnknown>> IUnknownPtrPtr1);

    public static native int DispCallFunc(Pointer<?> voidPtr1, ValuedEnum<CALLCONV> CALLCONV1, short VARTYPE1, int UINT1, Pointer<Short> VARTYPEPtr1, Pointer<Pointer<VARIANT>> VARIANTARGPtrPtr1, Pointer<VARIANT> VARIANTPtr1);

    public static native int LHashValOfNameSysA(ValuedEnum<SYSKIND> SYSKIND1, int LCID1);

    public static native int LHashValOfNameSys(ValuedEnum<SYSKIND> SYSKIND1, int LCID1);

    public static native int CreateTypeLib(ValuedEnum<SYSKIND> SYSKIND1, Pointer<Character> OLECHARPtr1, Pointer<Pointer<ICreateTypeLib>> ICreateTypeLibPtrPtr1);

    public static native int CreateTypeLib2(ValuedEnum<SYSKIND> SYSKIND1, Pointer<Pointer<ICreateTypeLib2>> ICreateTypeLib2PtrPtr1);

    public static native int LoadRegTypeLib(Pointer<GUID> REFGUID1, short WORD1, short WORD2, int LCID1, Pointer<Pointer<ITypeLib>> ITypeLibPtrPtr1);

    public static native int LoadTypeLib(Pointer<Character> OLECHARPtr1, Pointer<Pointer<ITypeLib>> ITypeLibPtrPtr1);

    public static native int LoadTypeLibEx(ValuedEnum<REGKIND> REGKIND1, Pointer<Pointer<ITypeLib>> ITypeLibPtrPtr1);

    public static native int QueryPathOfRegTypeLib(Pointer<GUID> REFGUID1, short WORD1, short WORD2, int LCID1, Pointer<Pointer<Byte>> LPBSTR1);

    public static native int RegisterTypeLib(Pointer<ITypeLib> ITypeLibPtr1, Pointer<Character> OLECHARPtr1, Pointer<Character> OLECHARPtr2);

    public static native int UnRegisterTypeLib(Pointer<GUID> REFGUID1, short WORD1, short WORD2, int LCID1, ValuedEnum<SYSKIND> SYSKIND1);

    public static native int RegisterTypeLibForUser(Pointer<ITypeLib> ITypeLibPtr1, Pointer<Character> OLECHARPtr1, Pointer<Character> OLECHARPtr2);

    public static native int UnRegisterTypeLibForUser(Pointer<GUID> REFGUID1, short WORD1, short WORD2, int LCID1, ValuedEnum<SYSKIND> SYSKIND1);

    public static native void ClearCustData(Pointer<CUSTDATA> LPCUSTDATA1);
}
