/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.bridj.Platform;
import org.bridj.relocated.org.objectweb.asm.AnnotationVisitor;
import org.bridj.relocated.org.objectweb.asm.Attribute;
import org.bridj.relocated.org.objectweb.asm.ClassReader;
import org.bridj.relocated.org.objectweb.asm.ClassVisitor;
import org.bridj.relocated.org.objectweb.asm.FieldVisitor;
import org.bridj.relocated.org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytecodeAnalyzer {
    private BytecodeAnalyzer() {
    }

    public static List<String[]> getNativeMethodSignatures(Class c) throws IOException {
        return BytecodeAnalyzer.getNativeMethodSignatures(BytecodeAnalyzer.getInternalName(c), Platform.getClassLoader(c));
    }

    public static List<String[]> getNativeMethodSignatures(String internalName, ClassLoader classLoader) throws IOException {
        return BytecodeAnalyzer.getNativeMethodSignatures(internalName, classLoader, new ArrayList<String[]>());
    }

    private static List<String[]> getNativeMethodSignatures(final String internalName, ClassLoader classLoader, final List<String[]> ret) throws IOException {
        ClassReader r = new ClassReader(BytecodeAnalyzer.readByteCode(internalName, classLoader));
        String p = r.getSuperName();
        if (p != null && !p.equals("java/lang/Object")) {
            BytecodeAnalyzer.getNativeMethodSignatures(p, classLoader, ret);
        }
        r.accept(new EmptyVisitor(){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (Modifier.isNative(access)) {
                    ret.add(new String[]{internalName, name, desc});
                }
                return null;
            }
        }, 7);
        return ret;
    }

    private static List<String> getFieldNames(String internalName, String recurseToInternalName, ClassLoader classLoader, final List<String> ret) throws IOException {
        ClassReader r = new ClassReader(BytecodeAnalyzer.readByteCode(internalName, classLoader));
        String p = r.getSuperName();
        if (p != null && !p.equals("java/lang/Object") && !recurseToInternalName.equals(internalName)) {
            BytecodeAnalyzer.getFieldNames(p, recurseToInternalName, classLoader, ret);
        }
        r.accept(new EmptyVisitor(){

            public FieldVisitor visitField(int i, String name, String string1, String string2, Object o) {
                ret.add(name);
                return null;
            }
        }, 7);
        return ret;
    }

    private static List<String> getMethodNames(String internalName, String recurseToInternalName, ClassLoader classLoader, final List<String> ret) throws IOException {
        ClassReader r = new ClassReader(BytecodeAnalyzer.readByteCode(internalName, classLoader));
        String p = r.getSuperName();
        if (p != null && !p.equals("java/lang/Object") && !recurseToInternalName.equals(internalName)) {
            BytecodeAnalyzer.getMethodNames(p, recurseToInternalName, classLoader, ret);
        }
        r.accept(new EmptyVisitor(){

            public MethodVisitor visitMethod(int i, String name, String string1, String string2, String[] strings) {
                ret.add(name);
                return null;
            }
        }, 7);
        return ret;
    }

    static String getInternalName(Class c) {
        return c.getName().replace('.', '/');
    }

    static URL getClassResource(Class c) throws FileNotFoundException {
        return BytecodeAnalyzer.getClassResource(BytecodeAnalyzer.getInternalName(c), Platform.getClassLoader(c));
    }

    static URL getClassResource(String internalClassName, ClassLoader classLoader) throws FileNotFoundException {
        String p = internalClassName + ".class";
        URL u = classLoader.getResource(p);
        if (u == null) {
            throw new FileNotFoundException("Resource '" + p + "'");
        }
        return u;
    }

    static byte[] readByteCode(String classInternalName, ClassLoader classLoader) throws FileNotFoundException, IOException {
        return BytecodeAnalyzer.readBytes(BytecodeAnalyzer.getClassResource(classInternalName, classLoader).openStream(), true);
    }

    static byte[] readBytes(InputStream in, boolean close) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((len = in.read(b)) > 0) {
            out.write(b, 0, len);
        }
        if (close) {
            in.close();
        }
        return out.toByteArray();
    }

    public static List<String> getFieldNames(Class c, Class recurseTo) throws IOException {
        return BytecodeAnalyzer.getFieldNames(BytecodeAnalyzer.getInternalName(c), BytecodeAnalyzer.getInternalName(recurseTo), Platform.getClassLoader(c), new ArrayList<String>());
    }

    public static List<String> getMethodNames(Class c, Class recurseTo) throws IOException {
        return BytecodeAnalyzer.getMethodNames(BytecodeAnalyzer.getInternalName(c), BytecodeAnalyzer.getInternalName(recurseTo), Platform.getClassLoader(c), new ArrayList<String>());
    }

    static class EmptyVisitor
    extends ClassVisitor {
        public EmptyVisitor() {
            super(262144);
        }

        public void visit(int i, int i1, String string, String string1, String string2, String[] strings) {
        }

        public void visitSource(String string, String string1) {
        }

        public void visitOuterClass(String string, String string1, String string2) {
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bln) {
            return null;
        }

        public void visitAttribute(Attribute atrbt) {
        }

        public void visitInnerClass(String string, String string1, String string2, int i) {
        }

        public FieldVisitor visitField(int i, String string, String string1, String string2, Object o) {
            return null;
        }

        public MethodVisitor visitMethod(int i, String string, String string1, String string2, String[] strings) {
            return null;
        }

        public void visitEnd() {
        }
    }
}

