/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.field.expression.resolver;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.saml.opensaml.integration.field.expression.resolver.UserFieldExpressionResolver;
import com.liferay.saml.opensaml.integration.resolver.UserResolver;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(property={"default=true", "display.index:Integer=50", "key=dynamic"}, service={UserFieldExpressionResolver.class})
public class DynamicUserFieldExpressionResolver
implements UserFieldExpressionResolver {
    private static final Log _log = LogFactoryUtil.getLog(DynamicUserFieldExpressionResolver.class);

    @Override
    public String getDescription(Locale locale) {
        return ResourceBundleUtil.getString((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, DynamicUserFieldExpressionResolver.class), (String)"match-a-user-field-chosen-dynamically-based-on-name-id-format");
    }

    @Override
    public String resolveUserFieldExpression(Map<String, List<Serializable>> incomingAttributeValues, UserResolver.UserResolverSAMLContext userResolverSAMLContext) {
        String userIdentifierExpression = this._resolverUserFieldExpression(userResolverSAMLContext.resolveSubjectNameFormat());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Dynamically resolved with user identifier expression: " + userIdentifierExpression));
        }
        return userIdentifierExpression;
    }

    private String _resolverUserFieldExpression(String subjectNameFormat) {
        if (Objects.equals(subjectNameFormat, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress")) {
            return "emailAddress";
        }
        return "screenName";
    }
}

