/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.field.expression.handler;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.model.ExpandoValueModel;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.SafeLdapContext;
import com.liferay.portal.security.ldap.SafeLdapFilter;
import com.liferay.portal.security.ldap.SafeLdapFilterConstraints;
import com.liferay.portal.security.ldap.SafeLdapFilterFactory;
import com.liferay.portal.security.ldap.SafeLdapNameFactory;
import com.liferay.portal.security.ldap.SafePortalLDAP;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import com.liferay.portal.security.ldap.validator.LDAPFilterException;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import com.liferay.saml.opensaml.integration.field.expression.handler.UserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.internal.field.expression.handler.DefaultUserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.processor.context.ProcessorContext;
import com.liferay.saml.opensaml.integration.processor.context.UserProcessorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"display.index:Integer=100", "prefix=expando", "processing.index:Integer=100"}, service={UserFieldExpressionHandler.class})
public class ExpandoUserFieldExpressionHandler
implements UserFieldExpressionHandler {
    private static final Log _log = LogFactoryUtil.getLog(ExpandoUserFieldExpressionHandler.class);
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;
    @Reference
    private LDAPFilterValidator _ldapFilterValidator;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    @Reference
    private LDAPSettings _ldapSettings;
    @Reference
    private LDAPUserImporter _ldapUserImporter;
    private int _processingIndex;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SafePortalLDAP _safePortalLDAP;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void bindProcessorContext(UserProcessorContext userProcessorContext) {
        for (String validFieldExpression : this.getValidFieldExpressions()) {
            if (Validator.isBlank((String)userProcessorContext.getValue(String.class, validFieldExpression))) continue;
            ProcessorContext.Bind userBind = userProcessorContext.bind(user -> this._getExpandoValue((User)user, validFieldExpression), this._processingIndex, validFieldExpression, this::_update);
            userBind.mapString(validFieldExpression, ExpandoValueModel::setData);
        }
    }

    @Override
    public User getLdapUser(long companyId, String userIdentifier, String userIdentifierExpression) throws Exception {
        List ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            String providerUrl = ldapServerConfiguration.baseProviderURL();
            if (Validator.isNull((String)providerUrl)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No provider URL defined in " + ldapServerConfiguration));
                continue;
            }
            User user = this._getLdapUser(ldapServerConfiguration.ldapServerId(), companyId, userIdentifier, userIdentifierExpression);
            if (user == null) continue;
            return user;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"User with the expando field ", userIdentifierExpression, "=", userIdentifier, " was not found in any LDAP servers"}));
        }
        return null;
    }

    @Override
    public String getSectionLabel(Locale locale) {
        return ResourceBundleUtil.getString((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, DefaultUserFieldExpressionHandler.class), (String)"user-custom-fields");
    }

    @Override
    public User getUser(long companyId, String userIdentifier, String userIdentifierExpression) throws PortalException {
        if (userIdentifier == null) {
            return null;
        }
        List expandoValues = this._expandoValueLocalService.getColumnValues(companyId, User.class.getName(), "CUSTOM_FIELDS", userIdentifierExpression, userIdentifier, -1, -1);
        if (expandoValues.size() > 1) {
            expandoValues.forEach(xva$0 -> StringBundler.concat((Object[])new Object[]{xva$0}));
            ArrayList userIds = new ArrayList();
            expandoValues.forEach(expandoValue -> userIds.add(expandoValue.getClassPK()));
            throw new PortalException(StringBundler.concat((Object[])new Object[]{"User expando column \"", userIdentifierExpression, "\" and value \"", userIdentifier, "\" must match only 1 user, but it matched ", userIds}));
        }
        Stream stream = expandoValues.stream();
        return stream.map(ExpandoValueModel::getClassPK).map(arg_0 -> ((UserLocalService)this._userLocalService).fetchUserById(arg_0)).findFirst().orElse(null);
    }

    @Override
    public List<String> getValidFieldExpressions() {
        ArrayList<String> validExpressions = new ArrayList<String>();
        long companyId = CompanyThreadLocal.getCompanyId();
        for (ExpandoColumn column : this._expandoColumnLocalService.getDefaultTableColumns(companyId, User.class.getName())) {
            validExpressions.add(column.getName());
        }
        return Collections.unmodifiableList(validExpressions);
    }

    @Override
    public boolean isSupportedForUserMatching(String userIdentifier) {
        return true;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._processingIndex = GetterUtil.getInteger((Object)properties.get("processing.index"));
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    private ExpandoValue _getExpandoValue(User user, String validUserFieldExpression) {
        ExpandoValue expandoValue = this._expandoValueLocalService.getValue(user.getCompanyId(), User.class.getName(), "CUSTOM_FIELDS", validUserFieldExpression, user.getUserId());
        if (expandoValue == null) {
            ExpandoTable table = null;
            try {
                table = this._expandoTableLocalService.getTable(user.getCompanyId(), User.class.getName(), "CUSTOM_FIELDS");
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
            ExpandoColumn column = this._expandoColumnLocalService.getColumn(table.getTableId(), validUserFieldExpression);
            expandoValue = this._expandoValueLocalService.createExpandoValue(0L);
            expandoValue.setCompanyId(user.getCompanyId());
            expandoValue.setClassName(User.class.getName());
            expandoValue.setColumnId(column.getColumnId());
            expandoValue.setClassPK(user.getUserId());
        }
        return expandoValue;
    }

    private User _getLdapUser(long ldapServerId, long companyId, String userIdentifier, String userIdentifierExpression) throws Exception {
        Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
        String attributeName = GetterUtil.getString((String)userExpandoMappings.getProperty(userIdentifierExpression));
        if (Validator.isBlank((String)attributeName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"User expando field ", userIdentifierExpression, " is not mapped for LDAP server ", ldapServerId}));
            }
            return null;
        }
        SafeLdapContext safeLdapContext = null;
        NamingEnumeration enumeration = null;
        try {
            LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
            if (safeLdapContext == null) {
                _log.error((Object)"Unable to bind to the LDAP server");
                User user = null;
                return user;
            }
            if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ID ", ldapServerId, " is no longer valid, company ", companyId, " now uses ", ldapServerConfiguration.ldapServerId()}));
                }
                User user = null;
                return user;
            }
            SafeLdapFilter safeLdapFilter = null;
            try {
                safeLdapFilter = SafeLdapFilterFactory.fromUnsafeFilter((String)ldapServerConfiguration.userSearchFilter(), (LDAPFilterValidator)this._ldapFilterValidator);
            }
            catch (LDAPFilterException ldapFilterException) {
                throw new LDAPFilterException("Invalid user search filter: ", (Throwable)ldapFilterException);
            }
            safeLdapFilter = safeLdapFilter.and(new SafeLdapFilter[]{SafeLdapFilterConstraints.eq((String)attributeName, (Object)userIdentifier)});
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName"));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enumeration = safeLdapContext.search(LDAPUtil.getBaseDNSafeLdapName((LDAPServerConfiguration)ldapServerConfiguration), safeLdapFilter, searchControls);
            if (enumeration.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enumeration.nextElement();
                Attributes attributes = this._safePortalLDAP.getUserAttributes(ldapServerId, companyId, safeLdapContext, SafeLdapNameFactory.from((Binding)binding));
                User user = this._ldapUserImporter.importUser(ldapServerId, companyId, safeLdapContext, attributes, null);
                return user;
            }
            User user = null;
            return user;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + exception.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            throw new SystemException("Problem accessing LDAP server " + exception.getMessage());
        }
        finally {
            if (enumeration != null) {
                enumeration.close();
            }
            if (safeLdapContext != null) {
                safeLdapContext.close();
            }
        }
    }

    private ExpandoValue _update(ExpandoValue currentExpandoValue, ExpandoValue newExpandoValue, ServiceContext serviceContext) throws PortalException {
        if (!newExpandoValue.isNew()) {
            return this._expandoValueLocalService.updateExpandoValue(newExpandoValue);
        }
        ExpandoColumn column = this._expandoColumnLocalService.getColumn(newExpandoValue.getColumnId());
        return this._expandoValueLocalService.addValue(newExpandoValue.getCompanyId(), User.class.getName(), "CUSTOM_FIELDS", column.getName(), newExpandoValue.getClassPK(), newExpandoValue.getData());
    }
}

