/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.runtime.configuration;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;

public class ServicesDropDownMetaTypeProvider
implements Closeable,
MetaTypeProvider {
    private String _attributeDescription;
    private String _attributeID;
    private String _attributeName;
    private Function<ServiceReference<?>, Object> _labelFunction;
    private String _metatypeDescription;
    private String _metatypeName;
    private String _metatypePID;
    private final ServiceTracker<KeyStoreManager, KeyStoreManager> _serviceTracker;
    private Function<ServiceReference<?>, String> _valuesFunction;

    public ServicesDropDownMetaTypeProvider(BundleContext bundleContext, String className, String metatypePID, String attributeID) {
        this(bundleContext, className, metatypePID, null, null, attributeID, null, null);
    }

    public ServicesDropDownMetaTypeProvider(BundleContext bundleContext, String className, String metatypePID, String metatypeName, String metatypeDescription, String attributeID, String attributeName, String attributeDescription) {
        this(bundleContext, className, metatypePID, metatypeName, metatypeDescription, attributeID, attributeName, attributeDescription, s -> s.getProperty("component.name"), s -> "(component.name=" + s.getProperty("component.name") + ")");
    }

    public ServicesDropDownMetaTypeProvider(BundleContext bundleContext, String className, String metatypePID, String metatypeName, String metatypeDescription, String attributeID, String attributeName, String attributeDescription, Function<ServiceReference<?>, Object> labelFunction, Function<ServiceReference<?>, String> valuesFunction) {
        this._metatypePID = metatypePID;
        this._metatypeName = metatypeName;
        this._metatypeDescription = metatypeDescription;
        this._attributeID = attributeID;
        this._attributeName = attributeName;
        this._attributeDescription = attributeDescription;
        this._labelFunction = labelFunction;
        this._valuesFunction = valuesFunction;
        try {
            Filter filter = bundleContext.createFilter(String.format("(&(objectClass=%s)(%s))", className, "component.name=*"));
            this._serviceTracker = new ServiceTracker(bundleContext, filter, null);
            this._serviceTracker.open();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException(className + " is an invalid class name", invalidSyntaxException);
        }
    }

    @Override
    public void close() throws IOException {
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
    }

    public String[] getLocales() {
        Set availableLocales = LanguageUtil.getAvailableLocales();
        Stream stream = availableLocales.stream();
        return (String[])stream.map(Locale::toLanguageTag).toArray(String[]::new);
    }

    public String getMetatypePID() {
        return this._metatypePID;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        return new ObjectClassDefinition(){

            public AttributeDefinition[] getAttributeDefinitions(int filter) {
                if (filter == 2 || filter == -1) {
                    return new AttributeDefinition[]{new AttributeDefinition(){

                        public int getCardinality() {
                            return 0;
                        }

                        public String[] getDefaultValue() {
                            return new String[0];
                        }

                        public String getDescription() {
                            return ServicesDropDownMetaTypeProvider.this._attributeDescription;
                        }

                        public String getID() {
                            return ServicesDropDownMetaTypeProvider.this._attributeID;
                        }

                        public String getName() {
                            return ServicesDropDownMetaTypeProvider.this._attributeName;
                        }

                        public String[] getOptionLabels() {
                            Stream stream = ServicesDropDownMetaTypeProvider.this._getServiceReferences();
                            return (String[])stream.map(ServicesDropDownMetaTypeProvider.this._labelFunction).toArray(String[]::new);
                        }

                        public String[] getOptionValues() {
                            Stream stream = ServicesDropDownMetaTypeProvider.this._getServiceReferences();
                            return (String[])stream.map(ServicesDropDownMetaTypeProvider.this._valuesFunction).toArray(String[]::new);
                        }

                        public int getType() {
                            return 1;
                        }

                        public String validate(String value) {
                            return null;
                        }
                    }};
                }
                return new AttributeDefinition[0];
            }

            public String getDescription() {
                return ServicesDropDownMetaTypeProvider.this._metatypeDescription;
            }

            public InputStream getIcon(int size) throws IOException {
                return null;
            }

            public String getID() {
                return ServicesDropDownMetaTypeProvider.this._metatypePID;
            }

            public String getName() {
                return ServicesDropDownMetaTypeProvider.this._metatypeName;
            }
        };
    }

    private Stream<ServiceReference<?>> _getServiceReferences() {
        ServiceReference[] serviceReferences = this._serviceTracker.getServiceReferences();
        if (serviceReferences == null) {
            return Stream.empty();
        }
        return Arrays.stream(serviceReferences);
    }
}

